function AdjustCont(action,imgvol)
% Demonstration of Image Contrast Adjustment
% [usage] AdjustCont('start',imgvol)
%          imgvol: a 2-D image volume
%
% Author: Chia-Feng Lu 2017.05.06

global handle_roi Data_roi

if strcmp(action,'start')
    handle_roi=[];
    Data_roi=[];
    
    if size(imgvol,3)>1
       imgvol=mean(imgvol,3);  
    end
    Data_roi.imgvol=imgvol;
    [Data_roi.row,Data_roi.col,Data_roi.slicenum]=size(imgvol);
    
    Data_roi.WindowCenter=[];
    Data_roi.WindowWidth=[];
    
    figpos =[0.1 0.1 0.8 0.7];
    handle_roi.main=figure('NumberTitle','off','Name','Demonstration of Image Contrast Adjustment, Chia-Feng Lu',...
        'Units','normalized','menubar','figure','toolbar','none',...
        'Position',figpos,'Colormap',gray(255));
    
    Data_roi.Lxlim=1;
    Data_roi.Uxlim=Data_roi.col;
    Data_roi.xlength=Data_roi.Uxlim-Data_roi.Lxlim+1;
    Data_roi.Lylim=1;
    Data_roi.Uylim=Data_roi.row;
    Data_roi.ylength=Data_roi.Uylim-Data_roi.Lylim+1;
    
    imgPos=[0.0 0.0 0.5 1.0];
    handle_roi.img_ax=axes('Parent',handle_roi.main,'Position',imgPos,...
        'YDir','reverse',...
        'XLim',[Data_roi.Lxlim Data_roi.Uxlim],...
        'YLim',[Data_roi.Lylim Data_roi.Uylim]);
    handle_roi.image=image('Parent',handle_roi.img_ax,'Cdata',[],...
        'XData',[1 Data_roi.xlength],'YData',[1 Data_roi.ylength],...
        'ButtonDownFcn','AdjustCont(''windowdown'')');
    axis off    
    
    handle_roi.axes_histo=axes('parent',handle_roi.main,'units','normalized',...
        'position',[0.55 0.1 0.40 0.85],'xgrid','on','ygrid','on','xlim',[0 255]);
    handle_roi.bar_histo=bar(handle_roi.axes_histo,1,1);
    
    AdjustCont('display')

elseif strcmp(action,'windowdown')
    set(gcf,'pointer','hand')
    Data_roi.pt1=get(handle_roi.img_ax,'CurrentPoint');
    Data_roi.pt1=round(Data_roi.pt1(1,1:2));
    set(gcf,'WindowButtonMotionFcn','AdjustCont(''windowmove'')');
    set(gcf,'WindowButtonUpFcn', 'AdjustCont(''windowup'')');
    
elseif strcmp(action,'windowmove')
    pt2=get(handle_roi.img_ax,'CurrentPoint');
    pt2=round(pt2(1,1:2));
    dcenter=(Data_roi.pt1(2)-pt2(2));   
    dwidth=(pt2(1)-Data_roi.pt1(1));    
    Data_roi.pt1=pt2;
    Data_roi.WindowCenter = Data_roi.WindowCenter + dcenter;
    Data_roi.WindowWidth = Data_roi.WindowWidth + dwidth;
    
    AdjustCont('display')
    
elseif strcmp(action,'windowup')
    set(gcf,'WindowButtonMotionFcn','AdjustCont(''focus'')');
    set(gcf,'WindowButtonUpFcn','');
    set(gcf,'Pointer','arrow');

elseif strcmp(action,'display')
    img=Data_roi.imgvol;
    
    if isempty(Data_roi.WindowWidth)
        Data_roi.WindowCenter=(max(img(:))+min(img(:)))/2;
        Data_roi.WindowWidth=(max(img(:))-min(img(:)));
    end
    
    oldmin=Data_roi.WindowCenter-0.5*Data_roi.WindowWidth;
    oldmax=Data_roi.WindowCenter+0.5*Data_roi.WindowWidth;
    img=scale(img,0,255,oldmin,oldmax);
    img(img<0)=0;
    img(img>255)=255;       
    set(handle_roi.image,'Cdata',img);    
    
    % update histogram
    [N,X]=hist(img(:),length(img(:))/1000);
    set(handle_roi.bar_histo,'xdata',X,'ydata',N)
    set(handle_roi.axes_histo,'xgrid','on','ygrid','on','xlim',[0 255])
    ylabel('Count'),xlabel('Intensity')
end    

%%%%%% scale function %%%%%%%%%
function sim = scale(im, newMin, newMax, oldMin, oldMax)
% scale(Image, newMin, newMax, oldMin, oldMax)
%	Scales an image such that its lowest value attains newMin and
%	its highest value attains newMax.  OldMin and oldMax are not
%	necessary but are useful when you don't want to use the true
%	min or max value.

delta = (newMax-newMin)/(oldMax-oldMin);
sim = delta*(im-oldMin) + newMin;


