%% load a JPEG image and perform thresholding
clear, close all

%% read JPED image and display with a threshold (overlapping disply)
img=imread('SCCtongue.jpg');
figure,
image(img),axis off
hold on

% set pixels with intensity less than 110 to be 0
ind=find(img<110);
img(ind)=0;

% set pixels with intensity larger than 110 to be red 
% (255 in the first layer and 0 in the second and third layers)
for layer=1:3 % red, green, and blue layer
    tmpimg=img(:,:,layer);
    ind=find(tmpimg>=110);
    if layer==1 % red
        tmpimg(ind)=255;
    else % green and blue layers
        tmpimg(ind)=0;
    end
    img(:,:,layer)=tmpimg;
end 
image(img,'alphadata',0.3),axis off
