%% Clear the Workspace and Command Window
clear, clc

%% Read the data from the sheet of TCGA_data in the TCGAGBM_data2.xlsx
% Note:Please load data in the worksheet of TCGA_data
[num, txt, raw]=xlsread('TCGAGBM_data2.xlsx',TCGA_data);  

%%  Extract the data of male subjects
% Note: Please find data for males
check_sex=ismember(raw(:,2),'male');
male_ind=find(check_sex==1);
raw_male=raw(male_ind);

%% Calculate the mean age of male subjects
% Note: the age for male subjects should be 59.0563.
mean_age=mean(num(male_ind-1,1));

%% Print out the mean age of male subjects in the Command Window
% Note: The message displayed in Command Window should be "The mean age of males is 59.0563."
fprintf('The mean age of male subjects is ' mean_age '.\n')
