% Demonstration for colormap setup
clear, close all

%% load image
load('footimg.mat')

img=(img-min(img(:)))/(max(img(:))-min(img(:)));
img=img*255;

%% customized image colormap
figure,
image(img), axis off
colormap(gray(256)), colorbar
% colormap(hot(256)), colorbar

figure,
image(img), axis off
cmap=[zeros(32,2) linspace(0,1,32)';...                                  % black -> blue
              linspace(0,1,64)' zeros(64,1) linspace(1,0,64)';...    % blue -> red
              ones(32,1) linspace(0,1,32)' zeros(32,1);...              % red -> yellow
              ones(128,2) linspace(0,1,128)'];                               % yellow -> white          
colormap(cmap), colorbar
