%% Perform Image Interpolation on local image region using Matlab
clear, close all

% get the image data of a DICOM file
img=dicomread('IM-0001-0081.dcm');

% extract a local region, perform interpolation and display in a new figure
img_local=img(45:200,170:340);
img_interp=imresize(img_local,4);
figure, imshow(img_interp,[],'border','tight')

%% perform image smoothing
kernal_sm=ones(15,15);
img_sm=conv2(double(img_interp),kernal_sm,'same');

figure, imshow(img_sm,[],'border','tight')

%% perform edge detection
kernal_lr=[1 0 -1;1 0 -1;1 0 -1];
img_lr=conv2(double(img_interp),kernal_lr,'same');
figure, imshow(abs(img_lr),[],'border','tight')

kernal_ap=[1 1 1;0 0 0;-1 -1 -1];
img_ap=conv2(double(img_interp),kernal_ap,'same');
figure, imshow(abs(img_ap),[],'border','tight')

img_edge=max(abs(img_lr),abs(img_ap));
figure, imshow(img_edge,[],'border','tight')
