% Perform the bootstrap on the portfolio data
% Author: Chia-Feng Lu, 2020.06.03
clear, close all

rng(0)
%% load Portfolio data: 
[num,txt,raw]=xlsread('Portfolio.csv');
X=num(:,1);  Y=num(:,2); 

%% Calculate the estimated alpha from the measurement
temp=cov(X,Y);
alpha_est = (var(Y)-temp(2))/(var(X)+var(Y)-2*temp(2));

%% Perform bootstrap sampling
alpha_bs = bootstrp(1000,@alpha_funct,X,Y);

mean(alpha_bs)  
std(alpha_bs) 
