function [Xt,Yt,Z]=plot_2D_gauss(mu,Sigma)
%% Plots the pdf of a 2D Gaussian as a surface
% From 'A first course in Machine Learning'
% Simon Rogers, 26th November 2009
% Modified by Chia-Feng Lu, 2020.03.25

% Create a dense grid of points at which to evaluate the pdf
[Xt,Yt] = meshgrid((mu(1)-2.2*Sigma(1,1)):0.1:(mu(1)+2.2*Sigma(1,1)),(mu(2)-2.2*Sigma(2,2)):0.1:(mu(2)+2.2*Sigma(2,2)));
% [Xt,Yt] = meshgrid(-5:0.1:5,-5:0.1:5);

% Compute the constant
const = 1/((2*pi)*sqrt(det(Sigma)));

% Evaluate the pdf at each grid point
Z = zeros(size(Xt));

for i = 1:numel(Xt)
    ve = [Xt(i);Yt(i)];    
    Z(i) = const * exp(-0.5 * (ve-mu')' * inv(Sigma)*(ve-mu'));%+...
%         0.7*const*exp(-0.5 * (ve-mu2)' * inv(Sigma)*(ve-mu2));
end

%% Create the contour plot and make it look nice
% figure
% contour(Xt,Yt,Z,7,'linewidth',1)
% colormap(gray)
% xlabel('$w_1$','interpreter','latex','fontsize',30)
% ylabel('$w_2$','interpreter','latex','fontsize',30)
