% Perform the K-nearest neighbor (KNN) regression
% Resource: https://enginius.tistory.com/662
clear, close all

%% Load Fisher's iris dataset
range = 1;
xall = [1 3 5 7 9 11 13 20 21 23 24 25 30]'*range;
yall = [0 3 2 6 1 0  2  4  5  6  10  5 0]';
xs   = linspace(0, 30*range, 100)';
k    = 3;

func = @(X)(get_knnregression(X, xall, yall, k));
outs = func(xs);

figure(1); clf; hold on;
plot(xall, yall, 'ko', 'MarkerSize', 15, 'LineWidth', 2);
plot(xs, outs, 'b-', 'LineWidth', 2);
title(sprintf('KNN REGRESSION [k:%d]', k), 'FontSize', 14);