function outs = get_knnregression(xs, xall, yall, k)
% KNN REGRESSION
% Resource: https://enginius.tistory.com/662

nx = size(xs, 1);
dy = size(yall, 2);
outs = zeros(nx, dy);
for xidx = 1:nx % FOR ALL TRAINING DATA
    x = xs(xidx, :);
    % FIRST FIND K CLOSEST INDICES
    [n, d]  = size(xall);
    xdiffs  = xall - repmat(x, n, 1);
    dsq     = zeros(n, 1);
    for i = 1:d
        dsq = dsq + xdiffs(:, i).^2;
    end
    ds = sqrt(dsq);
    [~, indices] = sort(ds, 'ascend');
    selidx  = indices(1:k);

    % COMPUTE WEIGHTS
    weights = ds(selidx);
    weights = exp(- 5 * weights / max(weights));
    weights = weights / sum(weights);
    
    % THEN, SIMPLY AVERAGE THEM 
    outs(xidx, :) = weights'*yall(selidx, :);
end