% Perform the Bagged classification tree using "fitcensemble" function
% Author: Chia-Feng Lu, 2021.03.29
clear, close all

%% load Heart data.
[num,txt,raw]=xlsread('Heart.csv');

excludeind=[];
% construct Table array
data=cell2table(raw(2:end,2:end));
for i=1:size(data,2)
    data.Properties.VariableNames{i}=raw{1,i+1}; % assign the VariableNames   
    
    % identify patients with missing data
    if iscell(data{:,i})
        tmpind=find(ismember(data{:,i},'NA'));  
    else
       tmpind=find(isnan(data{:,i}));  
    end
    excludeind=[excludeind, tmpind'];        
end
data(unique(excludeind),:)=[]; % remove the patients with missing data

%% Separate data into training (70%) and test (30%) datasets
rng(0,'twister')  % For reproducibility

C = cvpartition(size(data,1),'holdout',0.30); % randomly hold out 30% of subjects for test
dataTrain = data(C.training,:);
dataTest = data(C.test,:);

%% [Method 1] Construct a Bagged classification tree using all variables/features
% Construct a bagged classification tree using the training dataset
predictors={'Age', 'Sex', 'ChestPain', 'RestBP', 'Chol', 'Fbs', 'RestECG', 'MaxHR', 'ExAng', 'Oldpeak', 'Slope', 'Ca', 'Thal'};

t = templateTree; % For reproducibility of random predictor selections
tree_optimize = fitcensemble(dataTrain,'AHD','PredictorNames',predictors,...
    'Learners',t,...
     'OptimizeHyperparameters','all',...
    'HyperparameterOptimizationOptions',...
    struct('UseParallel',true,'AcquisitionFunctionName','expected-improvement-plus','kfold',5));

AHD_predict=predict(tree_optimize,dataTest);
[cm,order] = confusionmat(dataTest.AHD,AHD_predict)
accurarcy = trace(cm)/sum(cm(:))

%% Variable/Feature selection based on the importance scores
imp = predictorImportance(tree_optimize);

figure;
bar(imp);
title('Predictor Importance Estimates');
ylabel('Estimates');
xlabel('Predictors');
h = gca;
h.XTickLabel = tree_optimize.PredictorNames;
h.XTickLabelRotation = 45;
h.TickLabelInterpreter = 'none';

return
%% ClassifierLearner
classificationLearner
