% Perform the Bagged classification tree using "fitcensemble" function
% Author: Chia-Feng Lu, 2021.04.07
clear, close all

%% load Heart data.
[num,txt,raw]=xlsread('Heart.csv');

excludeind=[];
% construct Table array
data=cell2table(raw(2:end,2:end));
for i=1:size(data,2)
    data.Properties.VariableNames{i}=raw{1,i+1}; % assign the VariableNames   
    
    % identify patients with missing data
    if iscell(data{:,i})
        tmpind=find(ismember(data{:,i},'NA'));  
    else
       tmpind=find(isnan(data{:,i}));  
    end
    excludeind=[excludeind, tmpind'];        
end
data(unique(excludeind),:)=[]; % remove the patients with missing data

%% Separate data into training (70%) and test (30%) datasets
rng(0,'twister')  % For reproducibility

C = cvpartition(size(data,1),'holdout',0.30); % randomly hold out 30% of subjects for test
dataTrain = data(C.training,:);
dataTest = data(C.test,:);

%% [Method 1] Construct a SVM classifier using selected variables/features
% Construct a SVM classifier using the training dataset
rng(0,'twister')  % For reproducibility

include_fs=[8,10,12];
predictors={'MaxHR','Oldpeak', 'Ca'};

svm_model = fitcsvm(dataTrain,'AHD','PredictorNames',predictors,...
    'KernelFunction','rbf',...
    'OptimizeHyperparameters','auto',...
    'HyperparameterOptimizationOptions',...
    struct('AcquisitionFunctionName','expected-improvement-plus','kfold',5));

AHD_predict=predict(svm_model,dataTest);
[cm,order] = confusionmat(dataTest.AHD,AHD_predict)
accurarcy = trace(cm)/sum(cm(:))

%% display a 3-D scatter plot & SVM hyperplane (full dataset)
C1ind=find(ismember(dataTest.AHD,'Yes'));
C2ind=find(ismember(dataTest.AHD,'No'));    
figure, hold on
plot3(table2array(dataTest(C1ind,include_fs(1))),...
    table2array(dataTest(C1ind,include_fs(2))),...
    table2array(dataTest(C1ind,include_fs(3))),...
    'linestyle','none','marker','.','markersize',10,'color','r')
 plot3(table2array(dataTest(C2ind,include_fs(1))),...
    table2array(dataTest(C2ind,include_fs(2))),...
    table2array(dataTest(C2ind,include_fs(3))),...
    'linestyle','none','marker','.','markersize',10,'color','b')   

 d =0.05;  % grid interval
 [x, y, z] = meshgrid(min(table2array(dataTest(:,include_fs(1)))):d:max(table2array(dataTest(:,include_fs(1)))),...
    min(table2array(dataTest(:,include_fs(2)))):d:max(table2array(dataTest(:,include_fs(2)))), ...
    min(table2array(dataTest(:,include_fs(3)))):d:max(table2array(dataTest(:,include_fs(3)))));
 xGrid = [x(:),y(:),z(:)];
 [ ~ , f] = predict(svm_model,xGrid);
 f = reshape(f(:,2), size(x));
[faces,verts,~] = isosurface(x, y, z, f, 0, x);
 patch('Vertices', verts, 'Faces', faces, 'FaceColor','k','edgecolor', ...
 'none', 'FaceAlpha', 0.2);
xlabel(predictors{1}),ylabel(predictors{2}),zlabel(predictors{3})

grid on
% axis equal
box on
view(3)
