%% bayesclass.m
% From A First Course in Machine Learning, Chapter 5.
% Simon Rogers, 01/11/11 [simon.rogers@glasgow.ac.uk]
% Bayesian classifier
clear all;close all;

%% Load the data
%load ../data/bc_data

X=[
1.1107	-2.1079
-0.54984	0.094261
-0.03822	1.8829
0.055461	-0.61389
0.58702	-1.2067
0.54533	0.25093
-0.39275	-0.62204
-1.1905	-1.8785
-0.42401	0.77724
-0.71393	1.5846
-0.88831	2.1408
-0.69218	0.099297
1.435	1.2334
-0.75764	0.73858
-1.1144	-1.7059
0.66116	-1.7296
-2.1381	-0.060048
1.3857	1.2178
-1.4951	0.037283
0.80287	0.97385
1.5607	1.5862
0.8563	-1.4245
0.039702	-1.3799
1.2331	1.7421
-2.0015	0.8355
-0.34282	-0.47796
-0.8891	1.2634
0.3832	-0.11887
0.41725	1.0132
-0.86952	-0.79468
2.9737	3.6438
3.768	1.8649
0.11659	0.94352
0.68964	3.916
1.2234	2.9899
2.3009	0.41504
3.7693	3.8027
1.945	3.4208
0.92897	3.3611
5.0027	2.787
1.0101	1.8737
2.0751	2.2628
1.9113	3.6777
2.3127	3.913
1.9392	2.3976
3.1218	2.5495
1.7032	1.1509
0.4212	3.5322
2.7686	0.94019
2.1696	2.9285
0.33795	2.0947
3.6886	0.40537
2.6315	3.1962
-0.53322	3.1421
0.33796	3.0801
1.403	1.1841
2.8739	2.7777
1.1254	3.2404
0.098847	1.9522
0.36879	2.8904
1.4758	-1.6387
1.9289	-1.8191
2.5741	-1.3213
2.1917	-1.2852
0.83584	-2.3349
2.6863	-1.8834
3.1102	-0.48539
3.7073	-0.64662
3.6394	-0.40972
0.53652	-3.6555
2.9295	-0.38193
0.81685	-3.1133
1.3432	-1.7717
1.1039	-2.2261
1.3754	-2.2236
0.67575	-2.5379
-0.2029	-3.842
2.421	-1.9788
1.0335	-2.6042
0.96379	-2.9449
-0.81977	-5.4449
1.9552	-1.553
0.3505	-3.1887
2.4943	-1.8116
1.9761	-1.0664
0.59942	-3.0513
2.2076	-1.6728
1.9941	-1.8826
1.7487	-2.9644
1.416	-2.4234
];

t=[
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
2
2
2
2
2
2
2
2
2
2
2
2
2
2
2
2
2
2
2
2
2
2
2
2
2
2
2
2
2
2
3
3
3
3
3
3
3
3
3
3
3
3
3
3
3
3
3
3
3
3
3
3
3
3
3
3
3
3
3
3
];

% Plot the data
cl = unique(t);
col = {'ko','kd','ks'};
fcol = {[1 0 0],[0 1 0],[0 0 1]};
figure(1);
hold off
for c = 1:length(cl)
    pos = find(t==cl(c));
    plot(X(pos,1),X(pos,2),col{c},...
        'markersize',10,'linewidth',2,...
        'markerfacecolor',fcol{c});
    hold on
end
xlim([-3 7])
ylim([-6 6])

%% Repeat without Naive assumption
class_var = [];
for c = 1:length(cl)
    pos = find(t==cl(c));
    % Find the means
    class_mean(c,:) = mean(X(pos,:));
    class_var(:,:,c) = cov(X(pos,:),1);
end
%% Compute the predictive probabilities
Xv=2;
Yv=0 ;
Probs = [];
for c = 1:length(cl)
    temp = [Xv(:)-class_mean(c,1) Yv(:)-class_mean(c,2)];
    tempc = class_var(:,:,c);
    const = -log(2*pi) - log(det(tempc));
    Probs(:,:,c) = reshape(exp(const - 0.5*diag(temp*inv(tempc)*temp')),size(Xv));
end
[Probs(:,:,1) Probs(:,:,2) Probs(:,:,3) sum(Probs,3)]
    
Probs = Probs./repmat(sum(Probs,3),[1,1,3])

