%% Author: Lu, Chia-Feng 2013.11.08
clear, close all

%% initialize parameters
samplerate=1000; % in Hz
N=1024; % data length

sinefreq1=50; % in Hz
sinefreq2=100; % in Hz
sinefreq3=200; % in Hz

fl=75;   % low-cutoff frequency
fh=165;  % high-cutoff frequency
forder=6;
%% generate simulated signals 
t=[1:N]/samplerate;
sig1=sin(2*pi*sinefreq1*t);
sig2=sin(2*pi*sinefreq2*t);
sig3=sin(2*pi*sinefreq3*t);

data=sig1+sig2+sig3;

figure, 
subplot(4,1,1),plot(t,sig1),xlim([t(1) t(round(N/4))])
title([num2str(sinefreq1) '-Hz Sine Wave'])
subplot(4,1,2),plot(t,sig2),xlim([t(1) t(round(N/4))])
title([num2str(sinefreq2) '-Hz Sine Wave'])
subplot(4,1,3),plot(t,sig3),xlim([t(1) t(round(N/4))])
title([num2str(sinefreq3) '-Hz Sine Wave'])
subplot(4,1,4),plot(t,data),xlim([t(1) t(round(N/4))])
title(['Mixed signal'])
xlabel('Time (s)')

%% Apply 2-stage IIR filter processing
%%% lowpass filter
% data_2sIIR = filter_2sIIR(data,fl,samplerate,forder,'low'); 

%%% bandpass filter
% data_2sIIR = filter_2sIIR(data,fh,samplerate,forder,'bandpass'); 

%%% highpass filter
% data_2sIIR = filter_2sIIR(data,[fl fh],samplerate,forder,'high');  

%%% bandstop filter
% data_2sIIR = filter_2sIIR(data,[fl fh],samplerate,forder,'stop');  

figure, 
subplot(4,1,1),plot(t,sig1),xlim([t(1) t(round(N/4))])
title([num2str(sinefreq1) '-Hz Sine Wave'])
subplot(4,1,2),plot(t,sig2),xlim([t(1) t(round(N/4))])
title([num2str(sinefreq2) '-Hz Sine Wave'])
subplot(4,1,3),plot(t,sig3),xlim([t(1) t(round(N/4))])
title([num2str(sinefreq3) '-Hz Sine Wave'])
subplot(4,1,4),plot(t,data_2sIIR),xlim([t(1) t(round(N/4))])
title(['filtered signal with filter order = ' num2str(forder)])
xlabel('Time (s)')