%% Author: Lu, Chia-Feng 2013.11.08
clear, close all

%% initialize parameters
samplerate=1000; % in Hz
N=1024; % data length

sinefreq1=50; % in Hz
sinefreq2=100; % in Hz
sinefreq3=200; % in Hz

fl=75;   % low-cutoff frequency
fh=165;  % high-cutoff frequency
trans_width=20; % in Hz. It is a half of transition band. if data length is not long enough, increase trans_width

rp=1;  % in dB
rs=40; % in dB
%% generate simulated signals 
t=[1:N]/samplerate;
sig1=sin(2*pi*sinefreq1*t);
sig2=sin(2*pi*sinefreq2*t);
sig3=sin(2*pi*sinefreq3*t);

data=sig1+sig2+sig3;

figure, 
subplot(4,1,1),plot(t,sig1),xlim([t(1) t(round(N/4))])
title([num2str(sinefreq1) '-Hz Sine Wave'])
subplot(4,1,2),plot(t,sig2),xlim([t(1) t(round(N/4))])
title([num2str(sinefreq2) '-Hz Sine Wave'])
subplot(4,1,3),plot(t,sig3),xlim([t(1) t(round(N/4))])
title([num2str(sinefreq3) '-Hz Sine Wave'])
subplot(4,1,4),plot(t,data),xlim([t(1) t(round(N/4))])
title(['Mixed signal'])
xlabel('Time (s)')

%% Apply 3-stage IIR filter processing
%%% lowpass filter
[data_3sIIR,forder] = filter_3sIIR(data,fl-trans_width,fl+trans_width,rp,rs,samplerate,'low'); 

%%% bandpass filter
% [data_3sIIR,forder] = filter_3sIIR(data,[fl+trans_width fh-trans_width],[fl-trans_width fh+trans_width],rp,rs,samplerate,'bandpass'); 

%%% highpass filter
% [data_3sIIR,forder] = filter_3sIIR(data,fh+trans_width,fh-trans_width,rp,rs,samplerate,'high'); 

%%% bandstop filter
% [data_3sIIR,forder] = filter_3sIIR(data,[fl-trans_width fh+trans_width],[fl+trans_width fh-trans_width],rp,rs,samplerate,'stop');  

figure, 
subplot(4,1,1),plot(t,sig1),xlim([t(1) t(round(N/4))])
title([num2str(sinefreq1) '-Hz Sine Wave'])
subplot(4,1,2),plot(t,sig2),xlim([t(1) t(round(N/4))])
title([num2str(sinefreq2) '-Hz Sine Wave'])
subplot(4,1,3),plot(t,sig3),xlim([t(1) t(round(N/4))])
title([num2str(sinefreq3) '-Hz Sine Wave'])
subplot(4,1,4),plot(t,data_3sIIR),xlim([t(1) t(round(N/4))])
title(['filtered signal with filter order = ' num2str(forder)])
xlabel('Time (s)')