%% Author: Lu, Chia-Feng 2013.11.08
%% reference: John L. Semmlow, Biosignal and Biomedical Image Processing, p. 90
clear, close all

%% initialize parameters
samplerate=1000;   % in Hz
N=512;             % number of points, must be even, better be power of 2

%% define a and b coeffients of H (transfer function)
a = [1 -0.2 0.8];   % denominator terms
b = [0.2 0.5];      % numerator terms

%% option 1:compute the spectrum of H using fft
H = fft(b,N)./fft(a,N);    % compute H(f)

mag = 20*log10(abs(H));    % get magnitude of spectrum in dB
phase = angle(H)*2*pi;     % get phase in deg.

faxis=samplerate/2*linspace(0,1,N/2);  % the axis of frequency

%% option 2: compute the spectrum of H using freqz
% [H,faxis] = freqz(b,a,N,'whole',samplerate);
% 
% mag = 20*log10(abs(H));    % get magnitude of spectrum in dB
% phase = angle(H)*2*pi;     % get phase in deg.
% 
% faxis=samplerate/2*linspace(0,1,N/2);
% faxis=samplerate/2*linspace(0,1,N/2);  % the axis of frequency

%% plot the spectrum of H
figure,
subplot(2,1,1),plot(faxis,mag(1:N/2))
xlabel('Frequency (Hz)'),ylabel('Magnitude (dB)')
grid on

subplot(2,1,2),plot(faxis,phase(1:N/2),'r')
xlabel('Frequency (Hz)'),ylabel('Phase (deg.)')
grid on

