function [sigfilter, n]=filter_3sIIR(sig,wp,ws,rp,rs,fs,type)
% A three-stage IIR filter processing using Butterworth filter design
%
% The  input arguments are identical to those used in BUTTORD
%  sig: is the signal to be filtered arranged, each row is a measurement
%    f: a vector of cutoff frequencies in Hz. f is a number for lowpass and
%       highpass filters, and is a two-element vector for bandpass or bandstop
%       filter.
%   wp and ws are the passband and stopband edge frequencies, in Hz. For example,
%       Lowpass:    Wp = 60,      Ws = 65,
%       Highpass:   Wp = 125,     Ws = 120,
%       Bandpass:   Wp = [65 120], Ws = [60 125]
%       Bandstop:   Wp = [60 125], Ws = [65 120]
%   rp: loses no more than rp dB in the passband (3dB) and;
%   rs: has at least rs dB of attenuation in the stopband.
%   fs: the sampling frequency.
% type: 'low' for lowpass filter; 'high' for highpass filter; 
%       'bandpass' for bandpass filter; 'stop' for bandsto filter.
%
%  Details of input arguments and examples, please help BUTTORD.
%
%  [Author]: Lu, Chia-Feng 2013.11.08

if max([wp ws]/(fs/2))>=1
   error('The sampling frequency is not adequent for the given cutoff frequency, please input a lower f.') 
end

[n,wn]=buttord(wp/(fs/2),ws/(fs/2),rp,rs);
[b,a]=butter(n,wn,type);

sigfilter=[];
for i=1:size(sig,1)
    sigfilter(i,:) = filtfilt(b,a,sig(i,:));
end
