%% Author: Lu, Chia-Feng 2013.11.08
clear, close all

%% initialize parameters
fl=1;    % low-cutoff frequency, in Hz
fh=50;   % high-cutoff frequency, in Hz

forder=6;
%% load EEGdata
load('EEGdata.mat')

N=length(EEGdata);
taxis=[1:N]/samplerate;

%% filter the EEGdata
sigfilter1=filter_2sIIR(EEGdata',fh,samplerate,forder,'low')';

sigfilter2=filter_2sIIR(EEGdata',fl,samplerate,forder,'high')';

sigfilter3=filter_2sIIR(EEGdata',[fl fh],samplerate,forder,'bandpass')';

%% plot signal
figure, 
subplot(2,2,1),plot(taxis,EEGdata),title('Original EEG signal'),xlabel('Time (s)')
subplot(2,2,2),plot(taxis,sigfilter1),title('lowpass filtering'),xlabel('Time (s)')
subplot(2,2,3),plot(taxis,sigfilter2),title('highpass filtering'),xlabel('Time (s)')
subplot(2,2,4),plot(taxis,sigfilter3),title('bandpass filtering'),xlabel('Time (s)')
