%% Author: Lu, Chia-Feng 2013.11.08
clear, close all

%% initialize parameters
samplerate=400;   % in Hz
N=512;            % number of points, must be even, better be power of 2

L=128;            % length of filter coefficients
fl=60;            % low-cutoff frequency in Hz
fh=120;           % high-cutoff frequency in Hz
Ts=1/samplerate;  % in s
%% define b coeffients of H, lowpass filter
%%% option 1: bandpass
% b=[];
% for k=1:L+1
%     n=k-L/2;
%     if n==0
%         b(k)=fh-fl;
%     else
%         b(k)=sin(2*pi*fh*Ts*n)/(pi*n)-sin(2*pi*fl*Ts*n)/(pi*n);
%     end
% end

%%% option 2: lowpass
% b=[];
% for k=1:L+1
%     n=k-L/2;
%     if n==0
%         b(k)=fl;
%     else
%         b(k)=sin(2*pi*fl*Ts*n)/(pi*n);
%     end
% end

%%% option 3: highpass
% b=[];
% for k=1:L+1
%     n=k-L/2;
%     if n==0
%         b(k)=fh;
%     else
%         b(k)=sin(pi*n)/(pi*n)-sin(2*pi*fh*Ts*n)/(pi*n);
%     end
% end

%%% option 4: bandstop
b=[];
for k=1:L+1
    n=k-L/2;
    if n==0
        b(k)=fh-fl;
    else
        b(k)=sin(2*pi*fl*Ts*n)/(pi*n)+sin(pi*n)/(pi*n)-sin(2*pi*fh*Ts*n)/(pi*n);
    end
end

%% compute the spectrum of b with or without window function
H = fft(b,N);    % compute H(f)
mag = 20*log10(abs(H));    % get magnitude of spectrum in dB

HW = fft(b.*hamming(L+1)',N);    % compute H(f) with window function
magW = 20*log10(abs(HW));    % get magnitude of spectrum in dB

faxis=samplerate/2*linspace(0,1,N/2);  % the axis of frequency

%% plot the spectrum of H
figure,
subplot(2,1,1),plot(faxis,mag(1:N/2))
xlabel('Frequency (Hz)'),ylabel('Magnitude (dB)')
grid on

subplot(2,1,2),plot(faxis,magW(1:N/2))
xlabel('Frequency (Hz)'),ylabel('Magnitude (dB)')
grid on

