%% Author: Lu, Chia-Feng 2013.11.08
clear, close all

%% initialize parameters
samplerate=1000; % in Hz
N=1024; % data length

sinefreq1=50; % in Hz
sinefreq2=100; % in Hz
sinefreq3=200; % in Hz

fl=75;   % low-cutoff frequency
fh=165;  % high-cutoff frequency
trans_width=5; % in Hz. It is a half of transition band. if data length is not long enough, increase trans_width
%% generate simulated signals 
t=[1:N]/samplerate;
sig1=sin(2*pi*sinefreq1*t);
sig2=sin(2*pi*sinefreq2*t);
sig3=sin(2*pi*sinefreq3*t);

data=sig1+sig2+sig3;

figure, 
subplot(4,1,1),plot(t,sig1),xlim([t(1) t(round(N/4))])
title([num2str(sinefreq1) '-Hz Sine Wave'])
subplot(4,1,2),plot(t,sig2),xlim([t(1) t(round(N/4))])
title([num2str(sinefreq2) '-Hz Sine Wave'])
subplot(4,1,3),plot(t,sig3),xlim([t(1) t(round(N/4))])
title([num2str(sinefreq3) '-Hz Sine Wave'])
subplot(4,1,4),plot(t,data),xlim([t(1) t(round(N/4))])
title(['Mixed signal'])
xlabel('Time (s)')

%% Apply 3-stage FIR filter processing
%%% lowpass filter
% [data_3sFIR,forder] = filter_3sFIR(data,[fl-trans_width fl+trans_width],[1 0],[0.1 0.001],samplerate); 

%%% bandpass filter
% [data_3sFIR,forder] = filter_3sFIR(data,[fl-trans_width fl+trans_width fh-trans_width fh+trans_width],[0 1 0],[0.001 0.1 0.001],samplerate); 

%%% highpass filter
% [data_3sFIR,forder] = filter_3sFIR(data,[fh-trans_width fh+trans_width],[0 1],[0.001 0.1],samplerate); 

%%% bandstop filter
[data_3sFIR,forder] = filter_3sFIR(data,[fl-trans_width fl+trans_width fh-trans_width fh+trans_width],[1 0 1],[0.1 0.001 0.1],samplerate); 

figure, 
subplot(4,1,1),plot(t,sig1),xlim([t(1) t(round(N/4))])
title([num2str(sinefreq1) '-Hz Sine Wave'])
subplot(4,1,2),plot(t,sig2),xlim([t(1) t(round(N/4))])
title([num2str(sinefreq2) '-Hz Sine Wave'])
subplot(4,1,3),plot(t,sig3),xlim([t(1) t(round(N/4))])
title([num2str(sinefreq3) '-Hz Sine Wave'])
subplot(4,1,4),plot(t,data_3sFIR),xlim([t(1) t(round(N/4))])
title(['filtered signal with filter order = ' num2str(forder)])
xlabel('Time (s)')