%% Apply BiasField (estimated on the smoothed mean BOLD image) to all BOLD images
%% Author: Chia-Feng Lu, 2018.11.03
%% Modified by Chia-Feng Lu, 2019.04.01
clear all

addpath(['.' filesep 'niilib'])

%% set up target directory
dirname=uigetdir(pwd,'Please select a folder with preprocessed fMRI data');

typesel=listdlg('liststring',{'Normalized and Smoothed Data','Normalized Data'},...
                'promptstring','Please select the type of data you''d like to correct',...
                'selectionmode','single',...
                'name','Type selection',...
                'Listsize',[300 150]);

if  isempty(typesel)
     return
end

%% apply biasfield to each smoothed BOLD image
if typesel==1
    dirinfo=dir([dirname filesep 'swa*.nii']);
elseif typesel==2
    dirinfo=dir([dirname filesep 'wa*.nii']);
end

dirinfo2=dir([dirname filesep 'BiasField_wmeana*.nii']);
biasfield=double(readx([dirname filesep dirinfo2(1).name]));
for i=1:length(dirinfo)
    [img,info,info2]=readx([dirname filesep dirinfo(i).name]);
    newimg=double(img).*biasfield;
    for j=1:size(newimg,3)
        newimg(:,:,j)=flipud(newimg(:,:,j));
    end
    writex(newimg,[dirname filesep 'm' dirinfo(i).name],...
               info2.precision,info2.filetype,info);
end 

msgbox('Bias correction for the select data type is done!','Done')
    