function [varargout]=readx(varargin)
%sdt, nii, rec, dcm (.img, .dcm, none), bruker raw fid (none)
%input: readx() - open file select dialog
%       readx('filename.ext') - open the given file
%       readx('filename','type') - open the given extensionless file of the given type
%       readx('filename') - should usually find the correct file and type
%ouput: img=readx(...) - return the image
%       [img,info]=readx(...) - also return whatever header comes from the filetype
%       [img,info,info2]=readx(...) - also return a "standard" basic header info
%extensionless types: dicom-dcm, bruker raw fid-fid
%for bruker raw fid: the input filename can be 'fid' or a number of the
%       scan directory the fid file is in
%
%       modified by Chia-Feng Lu to read Bruker 2dseq 2015.7.21
        
switch nargin
    case 0
        [filename filepath] = uigetfile({'*.*','All'; '*.sdt','sdt'; '*.nii','nifti'});
        [filepath filename type]=fileparts([filepath filename]);
        filename=[filepath filesep filename];
        
        type=type(2:end);
    case 1
        [filepath filename type]=fileparts(varargin{1});
        filename=[filepath filesep filename];
        
        type=type(2:end);
        if isempty(type)
            type=findtype(filename);
        end
    case 2
        filename=varargin{1};
        type=varargin{2};
end

if isempty(type)
    if strcmpi(filename(end-4:end),'2dseq')  % Bruker 2dseq file
        sepind=find(filename==filesep);
        methodpath=[filename(1:sepind(end-2)) 'method'];
        if ~exist(methodpath,'file') % locate corresponding method file
            [tmpname tmppath] = uigetfile('*.*','Please select a mehod file');
            methodpath=[tmppath tmpname];
        end
        % read method and identify parameters
        fid=fopen(methodpath);
        methodtxt=textscan(fid,'%s','Delimiter','##','MultipleDelimsAsOne',1);
        fclose(fid);
        
        EffBval=[]; GradVec=[];
        for i=1:length(methodtxt{1})
            strtmp=methodtxt{1}{i};
            if length(strtmp)>=12 && strcmpi(strtmp(1:12),'$PVM_Matrix=')
                Matrix=str2num(methodtxt{1}{i+1});
            elseif length(strtmp)>=21 && strcmpi(strtmp(1:21),'$PVM_SPackArrNslices=')
                Nslices=str2num(methodtxt{1}{i+1});
            elseif length(strtmp)>=18 && strcmpi(strtmp(1:18),'$PVM_NRepetitions=')
                ind=find(strtmp=='=');
                NRepetitions=str2num(strtmp(ind+1:end));
            elseif length(strtmp)>=15 && strcmpi(strtmp(1:15),'$PVM_DwEffBval=')
                ind=find(strtmp=='=');
                NBval=str2num(strtmp(ind+1:end));
                
                linenum=1;
                while 1
                    tmp=methodtxt{1}{i+linenum};
                    if strcmp(tmp(1),'$')
                        break
                    end
                    EffBval=[EffBval str2num(tmp)];
                    linenum=linenum+1;
                end
            elseif length(strtmp)>=9 && strcmpi(strtmp(1:9),'$PVM_Fov=')
                FOV=str2num(methodtxt{1}{i+1});
            elseif length(strtmp)>=16 && strcmpi(strtmp(1:16),'$PVM_SliceThick=')
                ind=find(strtmp=='=');
                SliceThick=str2num(strtmp(ind+1:end));
            elseif length(strtmp)>=15 && strcmpi(strtmp(1:15),'$PVM_DwGradVec=')
                linenum=1;
                while 1
                    tmp=methodtxt{1}{i+linenum};
                    if strcmp(tmp(1),'$')
                        break
                    end
                    GradVec=[GradVec str2num(tmp)];
                    linenum=linenum+1;
                end    
            end
        end
        if exist('NBval','var')
            NRepetitions=NBval;
        end
        % write 2dseq.spr file
        fid=fopen([filename '.spr'],'w');
        if NRepetitions>1
            fprintf(fid,'numDim: 4\r\n');
            if length(Matrix)>2
                fprintf(fid,'dim: %d %d %d %d\r\n',Matrix(2),Matrix(1),Matrix(3),NRepetitions); % flip x and y for 3D
            else
                fprintf(fid,'dim: %d %d %d %d\r\n',Matrix(1),Matrix(2),Nslices,NRepetitions);
            end
        else
            fprintf(fid,'numDim: 3\r\n');
            if length(Matrix)>2
                fprintf(fid,'dim: %d %d %d\r\n',Matrix(2),Matrix(1),Matrix(3)); % flip x and y for 3D
            else
                fprintf(fid,'dim: %d %d %d\r\n',Matrix(1),Matrix(2),Nslices);
            end
        end
        fprintf(fid,'dataType: WORD\r\n');
        fprintf(fid,'sdtOrient: ax\r\n');
        fprintf(fid,'endia: ieee-le\r\n');
        if length(Matrix)>2
            fprintf(fid,'fov: %d %d %d\r\n',FOV(2),FOV(1),FOV(3)); % flip x and y for 3D
            fprintf(fid,'slicethick: %1.2f\r\n',FOV(3)/Matrix(3));
        else
            fprintf(fid,'fov: %d %d\r\n',FOV(1),FOV(2));
            fprintf(fid,'slicethick: %1.2f\r\n',SliceThick);
        end
        fclose(fid);
        
        copyfile(filename,[filename '.sdt']); % copy 2dseq as 2dseq.sdt
        type='sdt';
        
        if ~isempty(EffBval) && ~isempty(GradVec)
            tmpind=find(filename==filesep);
            filepath=filename(1:tmpind(end));
            
            GradVec=reshape(GradVec,3,[]);
            
            fid=fopen([filepath 'bvals'],'w');
            for i=1:length(EffBval)
                fprintf(fid,'%4.2f ',EffBval(i));
            end
            fclose(fid);
            
            fid=fopen([filepath 'bvecs'],'w');
            for i=1:size(GradVec,1)
                for j=1:size(GradVec,2)
                    fprintf(fid,'%1.4f ',GradVec(i,j));
                end
                fprintf(fid,'\r\n');
            end
            fclose(fid);
        end
    else
        type=findtype(filename);
    end
end

switch type
    case {'sdt','spr'}
        [img,info,info2]=readxsdt(filename);
        type='sdt';
    case 'nii'
        [img,info,info2]=readxnii(filename);
    case {'rec','par'}
        [img,info,info2]=readxrec(filename);
        type='rec';
    case {'dcm','img'}
        [img,info,info2]=readxdcm(filename);
        type='dcm';
    case 'fid'
        [img,info,info2]=readxfid(filename);
        img=cat(5,abs(img),angle(img));
end
info2.filetype=type;

switch nargout
    case 1
        varargout{1}=img;
    case 2
        varargout{1}=img; varargout{2}=info;
    otherwise
        varargout{1}=img; varargout{2}=info; varargout{3}=info2;
end
end



function [img,info,info2]=readxsdt(filename)
%read sdt file to a matrix img(NS,NP,Nsl,NR)

%  Qiang Shen, CCNI,UMMS
%[img,NS,NP,NI,NR,precision]=readsdt(filename,nr);
%if there is nr,read volume from 1 to nr, and NR=nr;
%if no nr,read all the data set;
sdtfname=strcat(filename,'.sdt');
sprfname=strcat(filename,'.spr');
f1=fopen(sprfname,'r');
fgetl(f1);
fgets(f1,4);
num=fscanf(f1,'%d');
NS=num(1);
NP=num(2);
sz=size(num);
if (sz(1)>2)
    NI=num(3);
else
    NI=1;
end
if (sz(1)==4)
    NR=num(4);
else
    NR=1;
end
%fgets(f1,10);
%datatype=fgets(f1,1);
done=0;
strbuf='dataType:';
while done==0
    line=fgetl(f1);
    if(strncmpi(line,strbuf,9))==1
        done=1;
        datatype=line(11);
    end
end
fclose(f1);
switch datatype
    case 'L'
        precision='int32';
    case 'W'
        precision='int16';
    case 'B'
        precision='char';
    case 'R' 
        precision='float32';
end
[f1 temp]=fopen(sdtfname,'r','l');
img = [];
img2 = fread(f1,inf,precision);
if length(img2)<NS*NP*NI*NR
while ~isempty(img2)
    img = [img; img2];
    img2 = fread(f1,inf,precision);
end
else
    img=img2; clear img2;
end
%[img count]=fread(f1,inf,precision);
%[message,errnum] = ferror(f1)
img=reshape(img,[NS,NP,NI,NR]);
info.d1=NS; info.d2=NP; info.d3=NI; info.d4=NR; info2.d5=1; info.precision=precision;
info2=info;
fclose(f1);
end

function [img,info,info2]=readxnii(filename)
% read in the .nii file
img_nii=load_nii([filename '.nii']);
info=img_nii.hdr;
img=img_nii.img;
if exist('load_nii_ext.m','file')
    ext=load_nii_ext([filename '.nii']);
    if ~isempty(ext), info.ext=ext; end;
end
info2.d1=info.dime.dim(2); info2.d2=info.dime.dim(3); info2.d3=info.dime.dim(4);
info2.d4=info.dime.dim(5); info2.d5=info.dime.dim(6);
switch info.dime.datatype
    case 2,     info2.precision='uint8';
    case 4,     info2.precision='int16';
    case 8,     info2.precision='int32';
    case 16,    info2.precision='float32';
    case 64,    info2.precision='float64';
    case 256,   info2.precision='int8';
    case 512,   info2.precision='uint16';
    case 768,   info2.precision='uint32';
    case 32,    info2.precision='complex64';
    case 128,   info2.precision='RGB24';
    case 1792,  info2.precision='complex128';
end
end

function [img,info,info2]=readxrec(fname)
%%% Read parameters from .PAR file
fpar=fopen([fname '.PAR'],'r');
done=0; flag_ImageInfo=0;
while done==0
    line=fgetl(fpar);
    if ~isempty(line)
        if line==-1
            break
        end
        if strcmp(line(1),'.')
            t=line(2:end);
            [t r]=strtok(t,':');
            t=strtrim(t);
            r=strtrim(strtok(r,':'));
            if ~isempty(strfind(t,'Acquisition nr'))
                scan_no=str2double(r);
            elseif ~isempty(strfind(t,'Protocol name'))
                [temp r]=strtok(r);
                outfile=strtrim(r);
            elseif ~isempty(strfind(t,'Max. number of dyn'))
                NR=str2double(r);
            elseif ~isempty(strfind(t,'FOV'))
                fov=str2num(r);
                fov=fov([1 3 2]);
            elseif ~isempty(strfind(t,'Max. number of card'))
                Ncp=str2double(r);
            elseif ~isempty(strfind(t,'Max. number of slices'))
                NS=str2double(r);
            end
        end
        if strcmp(line(1),'#') %Get 1st line of image information data
            t=strtrim(line(2:end));
            if ~isempty(strfind(t,'=== IMAGE INFORMATION ==='));
                line=fgetl(fpar); line=fgetl(fpar); line=fgetl(fpar);
                t=textscan(line,'%f64'); t=t{1};
                RO=t(10); PE=t(11); %reconstructed matrix size
                RI=t(12); RS=t(13); SS=t(14); %intensity scaling parameters
                TF=t(40); FA=t(36); %TFE factor and flip angle
                delay=t(41);
                flag_ImageInfo=1;
                ttime=zeros([NS NR*Ncp]); %delay times
            end
        end
        if flag_ImageInfo
            t=textscan(line,'%f64'); t=t{1};
            sl=t(1); dyn=t(3); ph=t(4); %slice#, dynamic#, cardiac phase#
            ttime(sl,ph+(dyn-1)*Ncp)=t(33); %cardiac delay times
        end
    else
        flag_ImageInfo=0;
    end
    
end
%%% information read from corresponding .PAR file
RO=RO;
PE=PE;
NS=NS;
NR=NR*Ncp;  % for ASL, dynamic = pair of danamics*2.  for cardiac phase, phase # =dyn #.
precis='int16';
res=[fov(1)/RO, fov(2)/PE, fov(3)];
info.fov=fov; info.RO=RO; info.PE=PE; info.NS=NS; info.res=res;
info.NR=NR; info.Ncp=Ncp; 
info.ttime=ttime; info.intensity.RI=RI; info.intensity.RS=RS; info.intensity.SS=SS;
info.delay=delay;
%%% read the image from .REC file
img=zeros([RO PE NS NR],precis);  % the 4D dataset sizes. Readout, Phase, Slice, Dynamics.
fid=fopen([fname '.REC'], 'r', 'l');
for k = 1:NS
for d = 1:NR
    img(:,:,k,d)= fread(fid, [RO PE], [precis '=>' precis]); % reads the number of elements specified by SIZE. 'int16'--integer 16 bits.
end
end
fclose(fid);
info2.d1=RO; info2.d2=PE; info2.d3=NS; info2.d4=NR; info2.d5=1; info2.precision=precis;
end

function [img,info,info2]=readxdcm(filename)
% read in the .dcm,.img, or extensionless dicom file
info=dicominfo(filename);
img=dicomread(info);
[info2.d1 info2.d2 info2.d3 info2.d4 info2.d5]=size(img);
exp=info.BitsAllocated;%ceil(log2(double(info.BitDepth)));
switch exp
    case 8
        info2.precision='uint8';
    case 16
        info2.precision='int16';
    case 32
        info2.precision='float32';
    case 64
        info2.precision='int64';
end
end

function [raw_imgspace,info,info2] = readxfid(varargin)
% function to read in a raw data, fid, from 7T
% input the path where the fid file is located 
% returns the complex image-space and complex k-space data

if(~exist('varargin','var')||isempty(varargin))
    [fname2,pathname]=uigetfile('*fid');
    %fname = [pathname fname];
    fname{1} = pathname;
    clear fname2;
    no_files=1;
else
    no_files=length(varargin);
    for ii=1:no_files
        if isnumeric(varargin{ii})
            fname{ii}=num2str(varargin{ii});
        else
            fname{ii}=varargin{ii};
        end
    end
end

warning off
for ii=1:no_files

pname1 = [fname{ii} '\acqp'];
pname2 = [fname{ii} '\method'];
pname3 = [fname{ii} '\pdata\1\reco'];

%%% read the ACQ parameters
ACQ_dim = getPPVb('acq_dim', pname1);
ACQ_size = getPPVa('acq_size',pname1);
NI = getPPVb('NI', pname1);     
%ACQ_obj_order = getPPVa('ACQ_obj_order', pname1);
ACQ_phase_factor = getPPVb('acq_phase_factor',pname1);
RF = ACQ_phase_factor;
%ACQ_phase_enc_mode = getPPVa('ACQ_phase_encoding_mode', pname1);
%ACQ_phase_enc_start = getPPVa('ACQ_phase_enc_start', pname1);
%ACQ_rare_factor = getPPVa('ACQ_rare_factor',pname1);
NSLICES = getPPVb('nslices',pname1);
NECHOES = getPPVb('nechoes',pname1);
NR = getPPVb('NR', pname1);
%GO_raw_data_format = getPPVa('GO_raw_data_format',pname1);
BYTORDA = getPPVb('BYTORDA', pname1);

%%% read RECO parameters
Offset = getPPVa('RECO_offset',pname3);
FTsize = getPPVa('RECO_ft_size',pname3);
FinalSize = getPPVa('RECO_size',pname3);
% FTsize=[256 288 25]; FinalSize=[128 128 15];
% Offset=[64 100 Offset(3)];

%%% read PVM parameters
Method = getPPVb('Method',pname2);
isEPI = ~isempty(strfind(Method,'EPI'));
if isEPI
    NSegments = getPPVb('NSegments',pname2);
end
EncMatrix = getPPVa('PVM_EncMatrix',pname2);
NF=EncMatrix(1); NP=EncMatrix(2);
PhaseEncoding = getPPVa('PVM_EncSteps1',pname2);
Matrix = getPPVa('PVM_Matrix',pname2);
Antialias = getPPVa('PVM_AntiAlias',pname2);
Zerofill(1) = getPPVb('PVM_EncZfRead',pname2);
Zerofill(2) = getPPVb('PVM_EncZfAccel1',pname2);
PartialFourier = getPPVb('PVM_EncPftAccel1',pname2);
SliceOrder = getPPVa('PVM_ObjOrderList',pname2);
if length(EncMatrix)==3
    NP2=EncMatrix(3);
    Zerofill(3) = getPPVb('PVM_EncZfAccel2',pname2);
    %NP2z=round(NP2*Zerofill(3));
    NP2z=FTsize(3);
    PhaseEncoding2 = getPPVa('PVM_EncSteps2',pname2);
end

%%% load data
if BYTORDA=='little' || BYTORDA=='LITTLE'
 fid = fopen(strcat(fname{ii},'\fid'),'r','l');
else
 fid = fopen(strcat(fname{ii},'\fid'),'r','b');
end

if fid==-1 error('Can not open files...'); end
tmp = fread(fid, 'int32=>float32');
tmp_sz = length(tmp);
pack;
tmp = tmp(1:2:tmp_sz) + i*tmp(2:2:tmp_sz);
size(tmp)


NF2= round(NF*(2^(ceil(log2(NF))-log2(NF)))); % NF is zerofilled to a power of 2 by Paravision
NF2=NF;
%NFz=round(NF*Zerofill(1)); NPz=round(NP*Zerofill(2));
NFz=FTsize(1); NPz=FTsize(2);
if isEPI
    tmp = reshape(tmp,NF2,NP/NSegments,NSLICES*NECHOES,NSegments,NR);
    tmp(:,2:2:NP/NSegments,:,:,:) = ...
        tmp(Matrix(1):-1:1,2:2:NP/NSegments,:,:,:);
    tmp2=zeros([NF2 NP NSLICES*NECHOES NR]);
    for jj=1:NSegments
        tmp2(:,1+(jj-1)*NP/NSegments:jj*NP/NSegments,:,:)=permute(tmp(:,:,:,jj,:),[1 2 3 5 4]);
    end
    tmp=tmp2;
    clear tmp2;
else
    if length(EncMatrix)==2
        tmp = reshape(tmp,NF2,NP,NSLICES,NR);
    elseif length(EncMatrix)==3
        tmp = reshape(tmp,NF2,NP,NP2*NSLICES,NR); 
    end
end
if PartialFourier~=1
    NP=round(NP*PartialFourier);
end
if length(EncMatrix)==2
    raw_kspace=zeros([NF2,NP,NSLICES,NR],'single');
    raw_kspace(:,PhaseEncoding+1+floor(Matrix(1)/2),SliceOrder+1,:)=tmp;
elseif length(EncMatrix)==3
    raw_kspace=zeros([NF2,NP,NP2*NSLICES,NR],'single');
    raw_kspace(:,PhaseEncoding+1+floor(EncMatrix(2)/2),PhaseEncoding2+1+floor(EncMatrix(3)/2),:)=tmp;
end
clear tmp
% if isEPI
%     for jj=1:NSegments
%       raw_kspace(:,min(PhaseEncoding)+jj+NSegments+Matrix(1)/2:NSegments*2:Matrix(2)*Antialias(2),...
%         :,:)  =  raw_kspace(Matrix(1):-1:1,...
%         min(PhaseEncoding)+jj+NSegments+Matrix(1)/2:NSegments*2:Matrix(2)*Antialias(2),:,:);
%     end
% end
fclose(fid);

end % close for all files input

if NF2~=NF %if frequency encode was not a power of 2
    raw_kspace=raw_kspace(1:NF,:,:,:);
end
if exist('NP2','var')
    if NF~=NFz || NP~=NPz || NP2~=NP2z
        rkt = zeros([NFz NPz NP2z*NSLICES NR],'single');
        rkt(1:NF,1:NP,1:NP2*NSLICES,:) = raw_kspace;
        raw_kspace=rkt;
        clear rkt;
    end
    if FTsize(1)~=NFz || FTsize(2)~=NPz || FTsize(3)~=NP2z
        rkt = zeros([FTsize(1) FTsize(2) FTsize(3)*NSLICES NR],'single');
        rkt(1:NFz,1:NPz,1:NP2z*NSLICES,:) = raw_kspace;
        raw_kspace=rkt;
        clear rkt;
        NFz=FTsize(1); NPz=FTsize(2); NP2z=FTsize(3);
    end
    if Matrix(1)~=FinalSize(1) || Matrix(2)~=FinalSize(2) || Matrix(3)~=FinalSize(3)
        Matrix(1)=FinalSize(1); Matrix(2)=FinalSize(2); Matrix(3)=FinalSize(3);
    end
else
    if NF~=NFz || NP~=NPz
        rkt = zeros([NFz NPz NSLICES NR],'single');
        rkt(1:NF,1:NP,1:NSLICES,:) = raw_kspace;
        raw_kspace=rkt;
        clear rkt;
    end
    if FTsize(1)~=NFz || FTsize(2)~=NPz
        rkt = zeros([FTsize(1) FTsize(2) NSLICES NR],'single');
        rkt(1:NFz,1:NPz,1:NSLICES,:) = raw_kspace;
        raw_kspace=rkt;
        clear rkt;
        NFz=FTsize(1); NPz=FTsize(2);
    end
    if Matrix(1)~=FinalSize(1) || Matrix(2)~=FinalSize(2)
        Matrix(1)=FinalSize(1); Matrix(2)=FinalSize(2);
    end
end

size(raw_kspace)
% center(1)=round(NF/2);
% center(2)=round(NP/2);

[cmin cind]=max(abs(mean(raw_kspace,4)),[],1);
[cmin cind2]=max(cmin,[],2);
if length(EncMatrix)==2
center(1)=cind(cind2)-1; center(2)=cind2-1;
elseif length(EncMatrix)==3
    [cmin cind3]=max(cmin,[],3);
    center(1)=cind(1,cind2(cind3),cind3)-1; center(2)=cind2(1,1,cind3)-1;
    center(3)=cind3-1;
end

% center(1)=round(NF/2);
% center(2)=find(sort(PhaseEncoding)==0)-1;
% if PartialFourier~=1
%     center(2)=center(2)+(NP-round(NP/PartialFourier));
% end

if length(EncMatrix)==2
    raw_kspace=circshift(raw_kspace,[-center(1) -center(2) 0 0]);
    raw_imgspace = zeros([Matrix(1) Matrix(2) NSLICES size(raw_kspace,4)],'single');
    for ii=1:size(raw_kspace,3)
        for jj=1:size(raw_kspace,4)
            temp = fftshift(fft2(raw_kspace(:,:,ii,jj)));
            raw_imgspace(:,:,ii,jj) = temp(Offset(1)+Matrix(1):-1:Offset(1)+1,...
                Offset(2)+Matrix(2):-1:Offset(2)+1);
        end
    end
    if Matrix(1)~=size(raw_kspace,1) || Matrix(2)~=size(raw_kspace,2)
        raw_kspace=zeros([Matrix(1) Matrix(2) NSLICES size(raw_kspace,4)],'single');
        for ii=1:size(raw_kspace,3)
            for jj=1:size(raw_kspace,4)
                temp = ifft2(raw_imgspace(:,:,ii,jj));
                raw_kspace(:,:,ii,jj) = temp;
            end
        end
    end
elseif length(EncMatrix)==3
    %center(3)=round(NP2/2);
    center(3)=find(sort(PhaseEncoding2)==0)-1;
    %raw_kspace=circshift(raw_kspace,[-center(1) -center(2) -center(3) 0]);
    for ii=1:size(raw_kspace,3)
        for jj=1:size(raw_kspace,4)
            raw_kspace(:,:,ii,jj)=raw_kspace([center(1)+1:NFz 1:center(1)],:,ii,jj);
        end
    end
    for ii=1:size(raw_kspace,3)
        for jj=1:size(raw_kspace,4)
            raw_kspace(:,:,ii,jj)=raw_kspace(:,[center(2)+1:NPz 1:center(2)],ii,jj);
        end
    end
    for ii=1:size(raw_kspace,1)
        for jj=1:size(raw_kspace,4)
            raw_kspace(ii,:,:,jj)=raw_kspace(ii,:,[center(3)+1:NP2z 1:center(3)],jj);
        end
    end
    raw_imgspace = zeros([Matrix(1) Matrix(2) Matrix(3) size(raw_kspace,4)],'single');
%     raw_imgspace = zeros([size(raw_kspace,1) size(raw_kspace,2) size(raw_kspace,3) size(raw_kspace,4)],'single');
    for jj=1:size(raw_kspace,4)
        temp = fftshift(fftn(raw_kspace(:,:,:,jj)));
        raw_imgspace(:,:,:,jj) = temp(Offset(1)+Matrix(1):-1:Offset(1)+1,...
                Offset(2)+Matrix(2):-1:Offset(2)+1,Offset(3)+Matrix(3):-1:Offset(3)+1);
%         raw_imgspace(:,:,:,jj) = temp;
    end
    if Matrix(1)~=size(raw_kspace,1) || Matrix(2)~=size(raw_kspace,2) || Matrix(3)~=size(raw_kspace,3)
        raw_kspace=zeros([Matrix(1) Matrix(2) Matrix(3) size(raw_kspace,4)],'single');
        for jj=1:size(raw_kspace,4)
        temp = ifftn(raw_imgspace(:,:,:,jj));
        raw_kspace(:,:,:,jj) = temp;
        end
    end
end
info.d1=NF; info.d2=NP; info.d3=NI; info.d4=NR; info.d5=1; info.precision='float32';
info2=info;
end

function type=findtype(filename)
if strcmp('fid',filename)||isnumeric(filename)
    type='fid';
else
    pfiles=dir(strcat(filename,'.*'));  pfiles={pfiles.name};
    [pathstr,name,ext]=fileparts(filename);
    [pfiles,pext]=strtok(pfiles,'.');
    pfileloc=strcmp(pfiles,name); pext=pext(pfileloc);
    if length(pext)>1
        filelist={'sdt','spr','nii','rec','par','dcm','img'};
        for ii=1:length(pext)
            pextTemp=pext{ii};
            filelistloc=strcmp(pextTemp(2:end),filelist);
            if any(filelistloc)
                type=filelist{filelistloc};
            end
        end
    elseif length(pext)==1
        pext=pext{1}; type=pext(2:end);
        if isempty(type)
            type='dcm';
        end
    else
        type='dcm';
    end
    clear pfileloc pfiles pext ii filelist filelistloc pextTemp pathstr name ext
end
end