% [Oddball]
% Transfer NIRSport raw data to HOMER2 data fromat
% Author: Chia-Feng Lu, 2015.05.13
clear all

%% load and tranfer raw data
dirname=uigetdir('Please select a folder with NIRsports data'); % please make sure the directory name is same with *.wl1 and *.wl2 files

if dirname~=0
    ind=find(dirname==filesep);
    filename=dirname(ind(end)+1:end);

    wl1=load([dirname filesep 'NIRS-' filename '.wl1' ]); % Location of .wl1 file
    wl2=load([dirname filesep 'NIRS-' filename '.wl2' ]); % Location of .wl2 file
    event=load([dirname filesep 'NIRS-' filename '.evt' ]); % Location of .evt file
    
    fs=6.25; % Sampling frequency for your experiment
    Ts=1/fs;

    t=[0:Ts:(size(wl1,1)-1)*Ts]'; % Time samples for th duration of recording.
    d=[wl1 wl2]; % Your data matrix from .wl1 and .wl2 files

    SD.Lambda=[760 850]; % The Wavelengths in the same order as you arranged your 'd' matrix above. 

    % you might need to figure out how your sensor arragement should be made
    % for the SD.SrcPos and SD.DetPos arrays. 
    % the coordinate can be defined using EIguide coordinates
    SD.SrcPos=[-6 10 0;
                6 10 0;
               -2 6 0;
                2 6 0;
               -6 6 0;
                6 6 0;
               -6 2 0;
                6 2 0]; % The x y z cooridnates of your source positions. x y z coordinates of [S1; S2; S3; S4 ;S5] plz check the diagram above for the coordinates.
    SD.DetPos=[-4 8 0;
                4 8 0;
               -8 8 0;
                8 8 0;
               -4 4 0;
                4 4 0;
               -8 4 0;
                8 4 0]; % The x y z coordinates of your Detector positions. x y z coordinates of [D1; D2; D3; D4 ;D5; D6; D7;D8;D9]
    SD.nSrcs=8; % No. of Sources
    SD.nDets=8; % No. of Detectors


    % SD.MeasList is a (nSrcs . nDets . no of wavelengths) X 4 Matrix     
    m1=[];
    for w=1:2 % 2 wavelength
        for i=1:SD.nSrcs
            m1=[m1; i*ones(SD.nDets,1)]; % the index of sourceNo. , repeat 2 wavelength
        end
    end
    m2=[];
    for w=1:2 % 2 wavelength
        for i=1:SD.nSrcs
            m2=[m2; [1:SD.nDets]']; % the index of detectorNo. , repeat 2 wavelength
        end
    end
    m3=ones(SD.nSrcs*SD.nDets*2,1); % all ones by default
    m4=[ones(SD.nSrcs*SD.nDets,1);2.*ones(SD.nSrcs*SD.nDets,1)];  % % label of wavelength
    
    ml=[m1 m2 m3 m4];

    % mask the signal for only preserving the good channel based on S-D design
    % first column is for source label; second column is for detector label
    GoodChanMask=[1 1;
                  1 3;
                  2 2;
                  2 4;
                  3 1;
                  3 5;
                  4 2;
                  4 6;
                  5 1;
                  5 3;
                  5 5;
                  5 7;
                  6 2;
                  6 4;
                  6 6;
                  6 8;
                  7 5;
                  7 7;
                  8 6;
                  8 8];
    GoodChanRow=[];
    for i=1:size(GoodChanMask,1)
        GoodChanRow=[GoodChanRow (GoodChanMask(i,1)-1)*SD.nDets+GoodChanMask(i,2)];
    end
    GoodChanRow=sort(GoodChanRow);
    GoodChanRow=[GoodChanRow GoodChanRow+SD.nSrcs*SD.nDets];
    
    d=d(:,GoodChanRow);
    ml=ml(GoodChanRow,:);
    
    SD.MeasList=ml;

    % Event file is converted from binary to decimal
    for i=1:size(event,1)
    evt(i,1) = event(i,1);
        %translating binary-markers to decimals
        evt(i,2) = bin2dec([num2str(event(i,9)) num2str(event(i,8)) num2str(event(i,7))...
                            num2str(event(i,6)) num2str(event(i,5)) num2str(event(i,4)) ...
                            num2str(event(i,3)) num2str(event(i,2))]);
    end

    id=find(evt(:,1)==0);
    evt(id,:)=[];

    % you might have to replace the marker values with your own values here.
    m.right=find(evt(:,2)==1)';  % 1 for right
    m.left=find(evt(:,2)==2)';  % 2 for left

    tevt.right=evt(m.right,1);  % right
    tevt.left=evt(m.left,1);    % left

    % the placemrks function develops a marker specific array such that it is 1 at the
    % time points at which the event or marker has occured and 0 otherwise. I
    % had 5 different groups of event for my experiment you might  want to
    % tweak in this for your own expt. 
    s = zeros(length(t),2); % for 2 conditions
    s(tevt.right,1)=1;
    s(tevt.left,2)=1;

    aux=t; % This can be any data of length of your 't' variable. 
    
    % s variable has my event markers for the homer to be used and finally you
    % can save the data i n.nirs format as shown.
    save([dirname filesep 'NIRS-' filename '.nirs' ],'t', 'd', 'SD', 's', 'ml', 'aux');
end