function MotionAna_UI(action)
% Author: Chia-Feng Lu 2014.04.02
global handle Data File

if nargin<1,
    action='start';
end;

%% start initial GUI parameter
if strcmp(action,'start'),
    %     clf reset;
    close all
    handle=[];
    Data=[];
    File=[];
    
    %%% plot handles
    handle.fig1=figure('units','normalize','position',[0.0  0.1 0.6 0.75]);
    handle.fig1_axes1=axes('parent',handle.fig1,'position',[0.1300    0.5838    0.5000    0.3412]);
    view(70,5),
    grid on,axis equal
    for i=1:4; handle.lineL(i)=line; end
    for i=1:2; handle.centerL(i)=line; end
    handle.projL(1)=line;
    for i=1:4; handle.lineR(i)=line; end
    for i=1:2; handle.centerR(i)=line; end
    handle.projR(1)=line;
    set(gca,'xgrid','on','ygrid','on','zgrid','on')
    colormap([1 0 0])
    
    handle.fig1_axes3=axes('parent',handle.fig1,'position',[ 0.1300    0.1100    0.3347    0.3412]);
    for i=1:2; handle.lineLHT(i)=line; end  % 1: Lt heel, 2: Lt toe, 3: Rt heel, 4: Rt toe
    grid on, %axis equal
    title('Left heel (blue) & toe (red)')
    ylabel('z-position trajectory')
    xlabel('time frame')
    handle.imageLSP=image('parent',handle.fig1_axes3,'xdata',[],'ydata',[],'cdata',[]);
    
    handle.fig1_axes4=axes('parent',handle.fig1,'position',[ 0.5703    0.1100    0.3347    0.3412]);
    for i=1:2; handle.lineRHT(i)=line; end  % 1: Lt heel, 2: Lt toe, 3: Rt heel, 4: Rt toe
    grid on, %axis equal
    title('Right heel (blue) & toe (red)')
    ylabel('z-position trajectory')
    xlabel('time frame')
    handle.imageRSP=image('parent',handle.fig1_axes4,'xdata',[],'ydata',[],'cdata',[]);
    
    handle.fig1_axes5=axes('parent',handle.fig1,'position',[ 0.1300    0.3300    0.3347    0.1212],'xticklabel','','visible','off');
    for i=1:3; handle.lineLKA(i)=line('visible','off'); end  
    grid on, %axis equal
    title('Left knee angle (green)')
    ylabel('x degree')
    handle.imageLKA=image('parent',handle.fig1_axes5,'xdata',[],'ydata',[],'cdata',[]);
    
    handle.fig1_axes6=axes('parent',handle.fig1,'position',[ 0.5703    0.3300    0.3347    0.1212],'xticklabel','','visible','off');
    for i=1:3; handle.lineRKA(i)=line('visible','off'); end  
    grid on, %axis equal
    title('Right knee angle (green)')
    ylabel('x degree')
    handle.imageRKA=image('parent',handle.fig1_axes6,'xdata',[],'ydata',[],'cdata',[]);
    
    handle.fig2=figure('units','normalize','position',[0.6  0.1 0.4 0.75],'toolbar','none');
    handle.fig2_axes1=axes('parent',handle.fig2,'position',[0.1300    0.5838    0.3347    0.3412]);
    handle.trajact(1)=line; 
    for i=1:4; handle.textpL(i)=text('string',''); end 
    for i=1:2; handle.largptL(i)=line; end
    set(gca,'xdir','reverse')
    xlabel('lateral <=> medial')
    ylabel('post. <=> ant.')
    
    handle.fig2_axes2=axes('parent',handle.fig2,'position',[0.5703    0.5838    0.3347    0.3412]);
    handle.trajact(2)=line; 
    for i=1:4; handle.textpR(i)=text('string',''); end 
    for i=1:2; handle.largptR(i)=line; end
    set(gca,'xdir','reverse')
    xlabel('medial <=> lateral')
    ylabel('post. <=> ant.')
    
    handle.fig2_axes3=axes('parent',handle.fig2,'position',[0.1300    0.3469    0.3347    0.1500]);
        handle.Lshifty=line; handle.GshiftyL=line; handle.hzero(1)=line('xdata',[0 1],'ydata',[0 0],'color','k');
        xlabel('normalized time of SP')
        ylabel('medial <=> lateral')    
    handle.fig2_axes4=axes('parent',handle.fig2,'position',[0.5703    0.3469    0.3347    0.1500],'ydir','reverse');
        handle.Rshifty=line; handle.GshiftyR=line; handle.hzero(2)=line('xdata',[0 1],'ydata',[0 0],'color','k');  
        xlabel('normalized time of SP')
        ylabel('medial <=> lateral')    
    handle.fig2_axes5=axes('parent',handle.fig2,'position',[0.1300    0.1100    0.3347    0.1500]);
        handle.Lshiftx=line; handle.GshiftxL=line; handle.hzero(3)=line('xdata',[0 1],'ydata',[0 0],'color','k');
        xlabel('normalized time of SP')
        ylabel('post. <=> ant.')    
    handle.fig2_axes6=axes('parent',handle.fig2,'position',[0.5703    0.1100    0.3347    0.1500]);
        handle.Rshiftx=line; handle.GshiftxR=line; handle.hzero(4)=line('xdata',[0 1],'ydata',[0 0],'color','k');
        xlabel('normalized time of SP')
        ylabel('post. <=> ant.')
        
    handle.fig2_axes7=axes('parent',handle.fig2,'position',[0.1300    0.3869    0.3347    0.1100],'xticklabel','','visible','off');
        handle.Langle=line('visible','off'); 
        for i=1:2; handle.GLangle(i)=line('visible','off'); end
        ylabel('angle'),xlim([0 1])     
    handle.fig2_axes8=axes('parent',handle.fig2,'position',[0.5703    0.3869    0.3347    0.1100],'xticklabel','','visible','off');
        handle.Rangle=line('visible','off'); 
        for i=1:2; handle.GRangle(i)=line('visible','off'); end
        ylabel('angle'),xlim([0 1])     
    handle.fig2_axes9=axes('parent',handle.fig2,'position',[0.1300    0.2469    0.3347    0.1100],'xticklabel','','visible','off');
        handle.Langvel=line('visible','off'); handle.hzero(5)=line('xdata',[0 1],'ydata',[0 0],'color','k','visible','off');
        for i=1:2; handle.GLangvel(i)=line('visible','off'); end
        ylabel('ang. vel.'),xlim([0 1])
    handle.fig2_axes10=axes('parent',handle.fig2,'position',[0.5703    0.2469    0.3347    0.1100],'xticklabel','','visible','off');
        handle.Rangvel=line('visible','off'); handle.hzero(6)=line('xdata',[0 1],'ydata',[0 0],'color','k','visible','off');
        for i=1:2; handle.GRangvel(i)=line('visible','off'); end
        ylabel('ang. vel.'),xlim([0 1])
    handle.fig2_axes11=axes('parent',handle.fig2,'position',[0.1300    0.1069    0.3347    0.1100],'visible','off');
        handle.Langacc=line('visible','off'); handle.hzero(7)=line('xdata',[0 1],'ydata',[0 0],'color','k','visible','off');
        for i=1:2; handle.GLangacc(i)=line('visible','off'); end
        ylabel('ang. accel.'),xlim([0 1])
        xlabel('normalized time of SP')
    handle.fig2_axes12=axes('parent',handle.fig2,'position',[0.5703    0.1069    0.3347    0.1100],'visible','off');
        handle.Rangacc=line('visible','off'); handle.hzero(8)=line('xdata',[0 1],'ydata',[0 0],'color','k','visible','off');
        for i=1:2; handle.GRangacc(i)=line('visible','off'); end
        ylabel('ang. accel.'),xlim([0 1]) 
        xlabel('normalized time of SP')   
    
    
    %%% control handles
    handle.LeftSP =  uicontrol('parent',handle.fig1,'Units','normalized',...
        'Style','Pushbutton',...
        'Position',[0.3447 0.0400 0.1200 0.04],...
        'Callback','MotionAna_UI(''LeftSP'')',...
        'String','Define SP');
    handle.RightSP =  uicontrol('parent',handle.fig1,'Units','normalized',...
        'Style','Pushbutton',...
        'Position',[0.7850 0.0400 0.1200 0.04],...
        'Callback','MotionAna_UI(''RightSP'')',...
        'String','Define SP');
    handle.kneeA =  uicontrol('parent',handle.fig1,'Units','normalized',...
        'Style','checkbox',...
        'Position',[0.4700 0.0400 0.2000 0.04],...
        'backgroundcolor',[.8 .8 .8],...
        'Callback','MotionAna_UI(''kneeA'')',...
        'String','Knee Angle');
    handle.Analyze =  uicontrol('parent',handle.fig1,'Units','normalized',...
        'Style','Pushbutton',...
        'Position',[0.2247 0.5138 0.1200 0.04],...
        'Callback','MotionAna_UI(''analyze'')',...
        'String','Analyze');
    handle.display =  uicontrol('parent',handle.fig1,'Units','normalized',...
        'Style','Pushbutton',...
        'Position',[0.3447 0.5138 0.1200 0.04],...
        'Callback','MotionAna_UI(''display'')',...
        'String','Display');
    handle.timeaxisL =  uicontrol('parent',handle.fig1,'Units','normalized',...
        'Style','slider',...
        'Position',[0.1300 0.4850 0.3347 0.025],...
        'Callback','MotionAna_UI(''timeaxisL'')',...
        'min',0,'max',10,...
        'sliderstep',[0.1 0.2]);
    handle.timetext =  uicontrol('parent',handle.fig1,'Units','normalized',...
        'Style','text',...
        'Position',[0.4647 0.4850 0.1056 0.025],...
        'string','0/0');
    handle.timeaxisR =  uicontrol('parent',handle.fig1,'Units','normalized',...
        'Style','slider',...
        'Position',[0.5703 0.4850 0.3347 0.025],...
        'Callback','MotionAna_UI(''timeaxisR'')',...
        'min',0,'max',10,...
        'sliderstep',[0.1 0.2]);
    
    %%% file handles
    handle.panel_filelist = uipanel('Parent',handle.fig1,...
        'Units','normalized',...
        'backgroundcolor',[0.8 0.8 0.8],...
        'Title','File list',...
        'Position',[0.6500    0.52    0.2550    0.4500],...
        'Fontsize',10,'Fontweight','bold');
    handle.filelist=uicontrol('Parent',handle.panel_filelist,...
        'Units','normalized',...
        'Style','listbox',...
        'BackgroundColor','white',...
        'ForegroundColor','black',...
        'Position',[0.01 0.01 0.59 0.98],...
        'Callback','MotionAna_UI(''filelist'')',...
        'String','',...
        'enable','off',...
        'max',2);
    handle.import =  uicontrol('Parent',handle.panel_filelist,...
        'Units','normalized',...
        'Style','Pushbutton',...
        'Position',[0.61 0.89 0.38 0.10],...
        'Callback','MotionAna_UI(''import'')',...
        'enable','on',...
        'String','Import');
    handle.remove =  uicontrol('Parent',handle.panel_filelist,...
        'Units','normalized',...
        'Style','Pushbutton',...
        'Position',[0.61 0.78 0.38 0.10],...
        'Callback','MotionAna_UI(''remove'')',...
        'enable','off',...
        'String','Remove');
    handle.clearall =  uicontrol('Parent',handle.panel_filelist,...
        'Units','normalized',...
        'Style','Pushbutton',...
        'Position',[0.61 0.67 0.38 0.10],...
        'Callback','MotionAna_UI(''clearall'')',...
        'enable','off',...
        'String','Clear all');
    handle.export =  uicontrol('Parent',handle.panel_filelist,...
        'Units','normalized',...
        'Style','Pushbutton',...
        'Position',[0.61 0.45 0.38 0.10],...
        'Callback','MotionAna_UI(''export'')',...
        'enable','on',...
        'String','Export');
    handle.exportall =  uicontrol('Parent',handle.panel_filelist,...
        'Units','normalized',...
        'Style','Pushbutton',...
        'Position',[0.61 0.34 0.38 0.10],...
        'Callback','MotionAna_UI(''exportall'')',...
        'enable','on',...
        'String','Export All');
    handle.load =  uicontrol('Parent',handle.panel_filelist,...
        'Units','normalized',...
        'Style','Pushbutton',...
        'Position',[0.61 0.12 0.38 0.10],...
        'Callback','MotionAna_UI(''loaddataset'')',...
        'enable','on',...
        'String','Load Dataset');
    handle.save =  uicontrol('Parent',handle.panel_filelist,...
        'Units','normalized',...
        'Style','Pushbutton',...
        'Position',[0.61 0.01 0.38 0.10],...
        'Callback','MotionAna_UI(''savedataset'')',...
        'enable','off',...
        'String','Save Dataset');
    
    handle.switchpop =  uicontrol('Parent',handle.fig2,...
        'Units','normalized',...
        'Style','popupmenu',...
        'Position',[0.13    0.005    0.3    0.05],...
        'Callback','MotionAna_UI(''switchpop'')',...
        'String','Projection translation|Knee angle info');
    
    File.filename={};
    File.filelist={};
    File.select=0;
    Data.LSPtime=[];
    Data.RSPtime=[];
    Data.samplerate=100; % in Hz
    Data.ycompL=0;
    Data.xcompL=0;
    Data.ycompR=0;
    Data.xcompR=0;
    
    Data.display_check=1; % 0 for performing analysis first
    
elseif strcmp(action,'import'),
    [filename1 filepath1]=uigetfile('*.csv','Please select the 1st file');
    [filename2 filepath2]=uigetfile('*.csv','Please select the 2nd file');
    
    h=waitbar(0,'Importing dataset please wait...');
    %%% process the 1st file
    [num,txt,raw]=xlsread([filepath1 filename1]);
    
    waitbar(0.2,h)
    for row=1:size(raw,1)
        for col=1:size(raw,2)
            if ~isempty(raw{row,col}) & length(raw{row,col})>=4
                if strcmpi(raw{row,col}(end-3:end),'LHEE')
                    LHEE_row=row-1;
                    LHEE_col=col;
                elseif strcmpi(raw{row,col}(end-3:end),'LTOE')
                    LTOE_row=row-1;
                    LTOE_col=col;
                elseif strcmpi(raw{row,col}(end-3:end),'LKNE')
                    LKNE_row=row-1;
                    LKNE_col=col;
                elseif strcmpi(raw{row,col}(end-3:end),'LTIB')
                    LTIB_row=row-1;
                    LTIB_col=col;
                elseif strcmpi(raw{row,col}(end-3:end),'RHEE')
                    RHEE_row=row-1;
                    RHEE_col=col;
                elseif strcmpi(raw{row,col}(end-3:end),'RTOE')
                    RTOE_row=row-1;
                    RTOE_col=col;
                elseif strcmpi(raw{row,col}(end-3:end),'RKNE')
                    RKNE_row=row-1;
                    RKNE_col=col;
                elseif strcmpi(raw{row,col}(end-3:end),'RTIB')
                    RTIB_row=row-1;
                    RTIB_col=col;
                end
            end
            
            if ~isempty(raw{row,col}) & length(raw{row,col})>=11
                if strcmpi(raw{row,col}(end-10:end),'LKneeAngles')
                    LKneeA_row=row-1;
                    LKneeA_col=col;
                elseif strcmpi(raw{row,col}(end-10:end),'RKneeAngles')
                    RKneeA_row=row-1;
                    RKneeA_col=col;
                end
            end
        end
    end
    
    check=1;
    framenum=0;
    row=LHEE_row+3;
    while check
        if ~isnan(num(row,LHEE_col))
            framenum=framenum+1;
            row=row+1;
        else
            check=0;
        end
        if row>size(num,1)
            check=0;
        end
    end
    
    Data.Lheel=num(LHEE_row+3:LHEE_row+3+framenum-1,LHEE_col:LHEE_col+2);
    Data.Ltoe=num(LTOE_row+3:LTOE_row+3+framenum-1,LTOE_col:LTOE_col+2);
    Data.LKNE_1=num(LKNE_row+3:LKNE_row+3+framenum-1,LKNE_col:LKNE_col+2);
    Data.LTIB_2=num(LTIB_row+3:LTIB_row+3+framenum-1,LTIB_col:LTIB_col+2);
    Data.LKneeA=num(LKneeA_row+3:LKneeA_row+3+framenum-1,LKneeA_col:LKneeA_col+2);
    Data.Rheel=num(RHEE_row+3:RHEE_row+3+framenum-1,RHEE_col:RHEE_col+2);
    Data.Rtoe=num(RTOE_row+3:RTOE_row+3+framenum-1,RTOE_col:RTOE_col+2);
    Data.RKNE_1=num(RKNE_row+3:RKNE_row+3+framenum-1,RKNE_col:RKNE_col+2);
    Data.RTIB_2=num(RTIB_row+3:RTIB_row+3+framenum-1,RTIB_col:RTIB_col+2);
    Data.RKneeA=num(RKneeA_row+3:RKneeA_row+3+framenum-1,RKneeA_col:RKneeA_col+2);
    
    Data.LKneeAY=Data.LKneeA(:,2); % 1 for x, 2 for y, 3 for z degree
    Data.LKneeV=diff(Data.LKneeAY); Data.LKneeV=[Data.LKneeV(1); Data.LKneeV];
    Data.LKneeAc=diff(Data.LKneeV); Data.LKneeAc=[Data.LKneeAc(1); Data.LKneeAc];
    Data.RKneeAY=Data.RKneeA(:,2); % 1 for x, 2 for y, 3 for z degree
    Data.RKneeV=diff(Data.RKneeAY); Data.RKneeV=[Data.RKneeV(1); Data.RKneeV];
    Data.RKneeAc=diff(Data.RKneeV); Data.RKneeAc=[Data.RKneeAc(1); Data.RKneeAc];
    
    waitbar(0.6,h)
    
    %%% process the 2nd file
    [num,txt,raw]=xlsread([filepath2 filename2]);
    
    waitbar(0.7,h)
    for row=1:size(raw,1)
        for col=1:size(raw,2)
            if ~isempty(raw{row,col}) & length(raw{row,col})>=4
                if strcmpi(raw{row,col}(end-3:end),'LTHI')
                    LTHI_row=row-1;
                    LTHI_col=col;
                elseif strcmpi(raw{row,col}(end-3:end),'LKNE')
                    LKNE_row=row-1;
                    LKNE_col=col;
                elseif strcmpi(raw{row,col}(end-3:end),'LTIB')
                    LTIB_row=row-1;
                    LTIB_col=col;
                elseif strcmpi(raw{row,col}(end-3:end),'LANK')
                    LANK_row=row-1;
                    LANK_col=col;
                elseif strcmpi(raw{row,col}(end-3:end),'RTHI')
                    RTHI_row=row-1;
                    RTHI_col=col;
                elseif strcmpi(raw{row,col}(end-3:end),'RKNE')
                    RKNE_row=row-1;
                    RKNE_col=col;
                elseif strcmpi(raw{row,col}(end-3:end),'RTIB')
                    RTIB_row=row-1;
                    RTIB_col=col;
                elseif strcmpi(raw{row,col}(end-3:end),'RANK')
                    RANK_row=row-1;
                    RANK_col=col;
                end
            end
        end
    end
    
    Data.LTHI_3=num(LTHI_row+3:LTHI_row+3+framenum-1,LTHI_col:LTHI_col+2);
    Data.LKNE_4=num(LKNE_row+3:LKNE_row+3+framenum-1,LKNE_col:LKNE_col+2);
    Data.LTIB_5=num(LTIB_row+3:LTIB_row+3+framenum-1,LTIB_col:LTIB_col+2);
    Data.LANK_6=num(LANK_row+3:LANK_row+3+framenum-1,LANK_col:LANK_col+2);
    Data.RTHI_3=num(RTHI_row+3:RTHI_row+3+framenum-1,RTHI_col:RTHI_col+2);
    Data.RKNE_4=num(RKNE_row+3:RKNE_row+3+framenum-1,RKNE_col:RKNE_col+2);
    Data.RTIB_5=num(RTIB_row+3:RTIB_row+3+framenum-1,RTIB_col:RTIB_col+2);
    Data.RANK_6=num(RANK_row+3:RANK_row+3+framenum-1,RANK_col:RANK_col+2);
    
    Data.dataL=[Data.Lheel Data.Ltoe Data.LKNE_1 Data.LTIB_2 Data.LTHI_3 Data.LKNE_4 Data.LTIB_5 Data.LANK_6];
    Data.dataR=[Data.Rheel Data.Rtoe Data.RKNE_1 Data.RTIB_2 Data.RTHI_3 Data.RKNE_4 Data.RTIB_5 Data.RANK_6];
    
    Data.alldataL=[Data.LKNE_1; Data.LTIB_2; Data.LTHI_3; Data.LKNE_4; Data.LTIB_5; Data.LANK_6; Data.Lheel;Data.Ltoe];
    
    Data.Lfemur_center=(Data.LKNE_1+Data.LTHI_3+Data.LKNE_4)/3;
    Data.Ltibia_center=(Data.LANK_6+Data.LTIB_2+Data.LTIB_5)/3;
    
    Data.alldataR=[Data.RKNE_1; Data.RTIB_2; Data.RTHI_3; Data.RKNE_4; Data.RTIB_5; Data.RANK_6; Data.Rheel;Data.Rtoe];
    
    Data.Rfemur_center=(Data.RKNE_1+Data.RTHI_3+Data.RKNE_4)/3;
    Data.Rtibia_center=(Data.RANK_6+Data.RTIB_2+Data.RTIB_5)/3;
    
    waitbar(1.0,h)
    
    %%% file handles
    inputcheck=1;
    while inputcheck
        filename=inputdlg('Please input the data name :), ex: sub01_trial01');
        if ~isempty(filename)
            File.filename{length(File.filename)+1}=filename{1};
            inputcheck=0;
        end
    end
    
    File.filelist{length(File.filename)}=Data;
    
    MotionAna_UI('updatafilelist')
    
    set(handle.remove,'enable','on');
    set(handle.clearall,'enable','on');
    set(handle.save,'enable','on');
    
    close(h)

elseif strcmp(action,'remove'),
    File.filelist(File.select)=[];
    File.filename(File.select)=[];
    
    MotionAna_UI('updatafilelist')
    
elseif strcmp(action,'clearall'),
    MotionAna_UI
    
elseif strcmp(action,'savedataset'),
    [filename filepath]=uiputfile('*.mat','Save the dataset as...');
    save([filepath, filename],'Data','File');
    
elseif strcmp(action,'loaddataset'),
    [filename filepath]=uigetfile('*.mat','Please select the dataset to read');
    load([filepath, filename]);   
    
    MotionAna_UI('updatafilelist')
    
    set(handle.remove,'enable','on');
    set(handle.clearall,'enable','on');
    set(handle.save,'enable','on');
    
elseif strcmp(action,'updatafilelist'),
    if isempty(File.filename)
        MotionAna_UI
    else
        File.select=length(File.filename);
        set(handle.filelist,'String',File.filename,'enable','on','value',File.select);
        MotionAna_UI('filelist')
    end
    
elseif strcmp(action,'filelist'),
    File.select=get(handle.filelist,'value');
    
    Data=File.filelist{File.select};
    
    set(handle.fig1_axes1,'xlim',[min([Data.alldataL(:,1);Data.alldataR(:,1)]) max([Data.alldataL(:,1);Data.alldataR(:,1)])],...
        'ylim',[min([Data.alldataL(:,2);Data.alldataR(:,2)]) max([Data.alldataL(:,2);Data.alldataR(:,2)])],...
        'zlim',[min([Data.alldataL(:,3);Data.alldataR(:,3)]) max([Data.alldataL(:,3);Data.alldataR(:,3)])])
    axes(handle.fig1_axes3),axis([1  size(Data.dataL,1) min([Data.Lheel(:,3); Data.Ltoe(:,3); Data.Rheel(:,3); Data.Rtoe(:,3)]) max([Data.Lheel(:,3); Data.Ltoe(:,3); Data.Rheel(:,3); Data.Rtoe(:,3)])])
    axes(handle.fig1_axes4),axis([1  size(Data.dataL,1) min([Data.Lheel(:,3); Data.Ltoe(:,3); Data.Rheel(:,3); Data.Rtoe(:,3)]) max([Data.Lheel(:,3); Data.Ltoe(:,3); Data.Rheel(:,3); Data.Rtoe(:,3)])])
    
    axes(handle.fig1_axes5),xlim([1  size(Data.dataL,1)]),ylim([min(Data.LKneeAY) max(Data.LKneeAY)])
    axes(handle.fig1_axes6),xlim([1  size(Data.dataL,1)]),ylim([min(Data.RKneeAY) max(Data.RKneeAY)])
    
    set(handle.timeaxisL,'min',1,'max',size(Data.dataL,1),'sliderstep',[1/size(Data.dataL,1) 10/size(Data.dataL,1)],'value',size(Data.dataL,1));
    set(handle.timeaxisR,'min',1,'max',size(Data.dataL,1),'sliderstep',[1/size(Data.dataL,1) 10/size(Data.dataL,1)],'value',size(Data.dataL,1));
    set(handle.timetext,'string',[num2str(size(Data.dataL,1)) '/' num2str(size(Data.dataL,1))])
    
    set(handle.lineLHT(1),'xdata',1:size(Data.dataL,1),'ydata',Data.Lheel(:,3),'color','b','marker','.','linestyle','-')
    set(handle.lineLHT(2),'xdata',1:size(Data.dataL,1),'ydata',Data.Ltoe(:,3),'color','r','marker','.','linestyle','-')
    
    set(handle.lineRHT(1),'xdata',1:size(Data.dataL,1),'ydata',Data.Rheel(:,3),'color','b','marker','.','linestyle','-')
    set(handle.lineRHT(2),'xdata',1:size(Data.dataL,1),'ydata',Data.Rtoe(:,3),'color','r','marker','.','linestyle','-')
    
    set(handle.lineLKA(1),'xdata',1:size(Data.dataL,1),'ydata',Data.LKneeAY,'color','g','marker','.','linestyle','-')
    set(handle.lineRKA(1),'xdata',1:size(Data.dataL,1),'ydata',Data.RKneeAY,'color','g','marker','.','linestyle','-')
    
    if isempty(Data.LSPtime)
        set(handle.imageLSP,'xdata',[],'ydata',[],'cdata',[])
        axes(handle.fig1_axes3),title('Left heel (blue) & toe (red)')
    else
        Trange=[min([Data.Lheel(:,3); Data.Ltoe(:,3); Data.Rheel(:,3); Data.Rtoe(:,3)]) max([Data.Lheel(:,3); Data.Ltoe(:,3); Data.Rheel(:,3); Data.Rtoe(:,3)])];
        set(handle.imageLSP,'xdata',[Data.LSPtime(1) Data.LSPtime(2)],...
            'ydata',Trange,...
            'cdata',ones(length(Data.LSPtime(1):Data.LSPtime(2)),length(Trange(1):Trange(2))),'alphadata',0.3)
        axes(handle.fig1_axes3)
        title(['Left heel (blue) & toe (red), SP=[' num2str(Data.LSPtime(1)) ', ' num2str(Data.LSPtime(2)) ']'])
    end
    
    if isempty(Data.RSPtime)
        set(handle.imageRSP,'xdata',[],'ydata',[],'cdata',[])
        axes(handle.fig1_axes4),title('Left heel (blue) & toe (red)')
    else
        Trange=[min([Data.Lheel(:,3); Data.Ltoe(:,3); Data.Rheel(:,3); Data.Rtoe(:,3)]) max([Data.Lheel(:,3); Data.Ltoe(:,3); Data.Rheel(:,3); Data.Rtoe(:,3)])];
        set(handle.imageRSP,'xdata',[Data.RSPtime(1) Data.RSPtime(2)],...
            'ydata',Trange,...
            'cdata',ones(length(Data.RSPtime(1):Data.RSPtime(2)),length(Trange(1):Trange(2))),'alphadata',0.3)
        axes(handle.fig1_axes4)
        title(['Left heel (blue) & toe (red), SP=[' num2str(Data.RSPtime(1)) ', ' num2str(Data.RSPtime(2)) ']'])
    end
    
    axislim=[min([Data.ycompL Data.ycompR]) max([Data.ycompL Data.ycompR]) min([Data.xcompL Data.xcompR]) max([Data.xcompL Data.xcompR])];
    if sum(axislim)~=0
        axes(handle.fig2_axes1),
        line('xdata',axislim(1:2),'ydata',[0 0],'color','k');
        line('xdata',[0 0],'ydata',axislim(3:4),'color','k');
        axis(axislim)
        axes(handle.fig2_axes2)
        line('xdata',axislim(1:2),'ydata',[0 0],'color','k');
        line('xdata',[0 0],'ydata',axislim(3:4),'color','k');
        axis(axislim)
        
        axes(handle.fig2_axes3),
        axis([0 1 axislim(1:2)])
        axes(handle.fig2_axes4),
        axis([0 1 axislim(1:2)])
        axes(handle.fig2_axes5),
        axis([0 1 axislim(3:4)])
        axes(handle.fig2_axes6),
        axis([0 1 axislim(3:4)])
        
        set(handle.largptL(1),'xdata',[],'ydata',[],'color','r','marker','o','linestyle','none','linewidth',2)
        set(handle.largptR(1),'xdata',[],'ydata',[],'color','r','marker','o','linestyle','none','linewidth',2)
        set(handle.trajact(1),'xdata',[],'ydata',[],'color','b','marker','.','linestyle','-')
        set(handle.trajact(2),'xdata',[],'ydata',[],'color','b','marker','.','linestyle','-')
        axes(handle.fig2_axes1),title('')
        axes(handle.fig2_axes2),title('')
    end
    
    Data.timept=size(Data.Lheel,1);
    MotionAna_UI('timeaxis'),

elseif strcmp(action,'kneeA'),    
    v=get(handle.kneeA,'value');
    if v==0
        set(handle.fig1_axes3,'position',[ 0.1300    0.1100    0.3347    0.3412])
        set(handle.fig1_axes4,'position',[ 0.5703    0.1100    0.3347    0.3412])
        set(handle.fig1_axes5,'visible','off')
        set(handle.fig1_axes6,'visible','off')
        set(handle.lineLKA(:),'visible','off')
        set(handle.lineRKA(:),'visible','off')
    else
        set(handle.fig1_axes3,'position',[ 0.1300    0.1100    0.3347    0.1800])
        set(handle.fig1_axes4,'position',[ 0.5703    0.1100    0.3347    0.1800])
        set(handle.fig1_axes5,'visible','on')
        set(handle.fig1_axes6,'visible','on')
        set(handle.lineLKA(:),'visible','on')
        set(handle.lineRKA(:),'visible','on')
    end
    
elseif strcmp(action,'switchpop'),      
    v=get(handle.switchpop,'value');
    if v==1
        set(handle.fig2_axes3,'visible','on')
        set(handle.Lshifty,'visible','on'), set(handle.GshiftyL,'visible','on')
        set(handle.fig2_axes4,'visible','on')
        set(handle.Rshifty,'visible','on'), set(handle.GshiftyR,'visible','on')
        set(handle.fig2_axes5,'visible','on')
        set(handle.Lshiftx,'visible','on'), set(handle.GshiftxL,'visible','on')
        set(handle.fig2_axes6,'visible','on')
        set(handle.Rshiftx,'visible','on'), set(handle.GshiftxR,'visible','on')
        set(handle.hzero(1:4),'visible','on')
        
        set(handle.fig2_axes7,'visible','off')
        set(handle.Langle,'visible','off'), set(handle.GLangle(:),'visible','off')
        set(handle.fig2_axes8,'visible','off')
        set(handle.Rangle,'visible','off'), set(handle.GRangle(:),'visible','off')
        set(handle.fig2_axes9,'visible','off')
        set(handle.Langvel,'visible','off'), set(handle.GLangvel(:),'visible','off')
        set(handle.fig2_axes10,'visible','off')
        set(handle.Rangvel,'visible','off'), set(handle.GRangvel(:),'visible','off')
        set(handle.fig2_axes11,'visible','off')
        set(handle.Langacc,'visible','off'), set(handle.GLangacc(:),'visible','off')
        set(handle.fig2_axes12,'visible','off')
        set(handle.Rangacc,'visible','off'), set(handle.GRangacc(:),'visible','off')
        set(handle.hzero(5:8),'visible','off')
    elseif v==2
        set(handle.fig2_axes3,'visible','off')
        set(handle.Lshifty,'visible','off'), set(handle.GshiftyL,'visible','off')
        set(handle.fig2_axes4,'visible','off')
        set(handle.Rshifty,'visible','off'), set(handle.GshiftyR,'visible','off')
        set(handle.fig2_axes5,'visible','off')
        set(handle.Lshiftx,'visible','off'), set(handle.GshiftxL,'visible','off')
        set(handle.fig2_axes6,'visible','off')
        set(handle.Rshiftx,'visible','off'), set(handle.GshiftxR,'visible','off')
        set(handle.hzero(1:4),'visible','off')
        
        set(handle.fig2_axes7,'visible','on')
        set(handle.Langle,'visible','on'), set(handle.GLangle(:),'visible','on')
        set(handle.fig2_axes8,'visible','on')
        set(handle.Rangle,'visible','on'), set(handle.GRangle(:),'visible','on')
        set(handle.fig2_axes9,'visible','on')
        set(handle.Langvel,'visible','on'), set(handle.GLangvel(:),'visible','on')
        set(handle.fig2_axes10,'visible','on')
        set(handle.Rangvel,'visible','on'), set(handle.GRangvel(:),'visible','on')
        set(handle.fig2_axes11,'visible','on')
        set(handle.Langacc,'visible','on'), set(handle.GLangacc(:),'visible','on')
        set(handle.fig2_axes12,'visible','on')
        set(handle.Rangacc,'visible','on'), set(handle.GRangacc(:),'visible','on')
        set(handle.hzero(5:8),'visible','on')
    end
    
    
elseif strcmp(action,'LeftSP'),
    Data.display_check=0;
    set(handle.fig1,'pointer','crosshair');
    set(handle.fig1_axes3,'buttondownfcn','MotionAna_UI(''downL'')');
    set(handle.lineLHT(1),'buttondownfcn','MotionAna_UI(''downL'')');
    set(handle.lineLHT(2),'buttondownfcn','MotionAna_UI(''downL'')');
    set(handle.fig1,'windowbuttonmotionfcn','MotionAna_UI(''moveL'')');
    Data.LSPtime=[];
    set(handle.imageLSP,'xdata',[],'ydata',[],'cdata',[])
    
    axes(handle.fig1_axes3)
    title('Left heel (blue) & toe (red)')
elseif strcmp(action,'moveL'),
    tmp=get(handle.fig1_axes3,'currentpoint');
    tmp=tmp(1);
    if ~isempty(Data.LSPtime)
        Trange=[min([Data.Lheel(:,3); Data.Ltoe(:,3); Data.Rheel(:,3); Data.Rtoe(:,3)]) max([Data.Lheel(:,3); Data.Ltoe(:,3); Data.Rheel(:,3); Data.Rtoe(:,3)])];
        set(handle.imageLSP,'xdata',[Data.LSPtime tmp],...
            'ydata',Trange,...
            'cdata',ones(length(Data.LSPtime:tmp),length(Trange(1):Trange(2))),'alphadata',0.3)
        
        axes(handle.fig1_axes3)
        title(['Left heel (blue) & toe (red), SP=[' num2str(Data.LSPtime(1)) ', ' num2str(round(tmp)) ']'])
    else
        axes(handle.fig1_axes3)
        title(['Left heel (blue) & toe (red), SP=[' num2str(round(tmp)) ', ?]'])
    end
elseif strcmp(action,'downL'),
    if isempty(Data.LSPtime)
        tmp=get(handle.fig1_axes3,'currentpoint');
        Data.LSPtime=round(tmp(1));
        set(handle.fig1_axes3,'buttondownfcn','MotionAna_UI('''')');
        set(handle.lineLHT(1),'buttondownfcn','MotionAna_UI('''')');
        set(handle.lineLHT(2),'buttondownfcn','MotionAna_UI('''')');
        set(handle.imageLSP,'buttondownfcn','MotionAna_UI(''downL'')');
        
        axes(handle.fig1_axes3)
        title(['Left heel (blue) & toe (red), SP=[' num2str(Data.LSPtime) ', ?]'])
    else
        tmp=get(handle.fig1_axes3,'currentpoint');
        Data.LSPtime=[Data.LSPtime round(tmp(1))];
        
        Trange=[min([Data.Lheel(:,3); Data.Ltoe(:,3); Data.Rheel(:,3); Data.Rtoe(:,3)]) max([Data.Lheel(:,3); Data.Ltoe(:,3); Data.Rheel(:,3); Data.Rtoe(:,3)])];
        set(handle.imageLSP,'xdata',[Data.LSPtime(1) Data.LSPtime(2)],...
            'ydata',Trange,...
            'cdata',ones(length(Data.LSPtime(1):Data.LSPtime(2)),length(Trange(1):Trange(2))),'alphadata',0.3)
        set(handle.fig1,'pointer','arrow');
        set(handle.imageLSP,'buttondownfcn','MotionAna_UI('''')');
        set(handle.fig1,'windowbuttonmotionfcn','MotionAna_UI('''')');
        
        axes(handle.fig1_axes3)
        title(['Left heel (blue) & toe (red), SP=[' num2str(Data.LSPtime(1)) ', ' num2str(Data.LSPtime(2)) ']'])
        
        File.select=get(handle.filelist,'value');
        File.filelist{File.select}=Data;
    end
    
elseif strcmp(action,'RightSP'),
    Data.display_check=0;
    set(handle.fig1,'pointer','crosshair');
    set(handle.fig1_axes4,'buttondownfcn','MotionAna_UI(''downR'')');
    set(handle.lineRHT(1),'buttondownfcn','MotionAna_UI(''downR'')');
    set(handle.lineRHT(2),'buttondownfcn','MotionAna_UI(''downR'')');
    set(handle.fig1,'windowbuttonmotionfcn','MotionAna_UI(''moveR'')');
    Data.RSPtime=[];
    set(handle.imageRSP,'xdata',[],'ydata',[],'cdata',[])
    
    axes(handle.fig1_axes4)
    title('Right heel (blue) & toe (red)')
elseif strcmp(action,'moveR'),
    tmp=get(handle.fig1_axes4,'currentpoint');
    tmp=tmp(1);
    if ~isempty(Data.RSPtime)
        Trange=[min([Data.Lheel(:,3); Data.Ltoe(:,3); Data.Rheel(:,3); Data.Rtoe(:,3)]) max([Data.Lheel(:,3); Data.Ltoe(:,3); Data.Rheel(:,3); Data.Rtoe(:,3)])];
        set(handle.imageRSP,'xdata',[Data.RSPtime tmp],...
            'ydata',Trange,...
            'cdata',ones(length(Data.RSPtime:tmp),length(Trange(1):Trange(2))),'alphadata',0.3)
        
        axes(handle.fig1_axes4)
        title(['Right heel (blue) & toe (red), SP=[' num2str(Data.RSPtime(1)) ', ' num2str(round(tmp)) ']'])
    else
        axes(handle.fig1_axes4)
        title(['Right heel (blue) & toe (red), SP=[' num2str(round(tmp)) ', ?]'])
    end
elseif strcmp(action,'downR'),
    if isempty(Data.RSPtime)
        tmp=get(handle.fig1_axes4,'currentpoint');
        Data.RSPtime=round(tmp(1));
        set(handle.fig1_axes4,'buttondownfcn','MotionAna_UI('''')');
        set(handle.lineRHT(1),'buttondownfcn','MotionAna_UI('''')');
        set(handle.lineRHT(2),'buttondownfcn','MotionAna_UI('''')');
        set(handle.imageRSP,'buttondownfcn','MotionAna_UI(''downR'')');
        
        axes(handle.fig1_axes4)
        title(['Right heel (blue) & toe (red), SP=[' num2str(Data.RSPtime) ', ?]'])
    else
        tmp=get(handle.fig1_axes4,'currentpoint');
        Data.RSPtime=[Data.RSPtime round(tmp(1))];
        
        Trange=[min([Data.Lheel(:,3); Data.Ltoe(:,3); Data.Rheel(:,3); Data.Rtoe(:,3)]) max([Data.Lheel(:,3); Data.Ltoe(:,3); Data.Rheel(:,3); Data.Rtoe(:,3)])];
        set(handle.imageRSP,'xdata',[Data.RSPtime(1) Data.RSPtime(2)],...
            'ydata',Trange,...
            'cdata',ones(length(Data.RSPtime(1):Data.RSPtime(2)),length(Trange(1):Trange(2))),'alphadata',0.3)
        set(handle.fig1,'pointer','arrow');
        set(handle.imageRSP,'buttondownfcn','MotionAna_UI('''')');
        set(handle.fig1,'windowbuttonmotionfcn','MotionAna_UI('''')');
        
        axes(handle.fig1_axes4)
        title(['Right heel (blue) & toe (red), SP=[' num2str(Data.RSPtime(1)) ', ' num2str(Data.RSPtime(2)) ']'])
        
        File.select=get(handle.filelist,'value');
        File.filelist{File.select}=Data;
    end
    
elseif strcmp(action,'analyze'),
    h=waitbar(0,'Analyzing marker data...');
    
    Data.ycompL=0;
    Data.xcompL=0;
    Data.ycompR=0;
    Data.xcompR=0;
    
    if length(Data.LSPtime)==2
        interval=[Data.LSPtime(1):Data.LSPtime(2)];
        for i=1:length(interval)
            %%% for left
            %%% calculate the distance between the center of mass (on femur plane) and the projection point of the center of mass (on tibia
            %%% plane) on the femur plane
            surfaceN=cross(Data.LTHI_3(interval(i),:)-Data.LKNE_1(interval(i),:),Data.LKNE_4(interval(i),:)-Data.LKNE_1(interval(i),:));  % cross to decide the normal of surface
            % surface equation: a(x-x0)+b(y-y0)+c(z-z0)=0; => ax+by+cz+d=0,  d=-ax0-by0-cz0, (x0,y0,z0) is on the surface
            a=surfaceN(1); b=surfaceN(2); c=surfaceN(3);
            d=-a*Data.LKNE_1(interval(i),1)-b*Data.LKNE_1(interval(i),2)-c*Data.LKNE_1(interval(i),3);
            
            % calculate the projection point
            px=Data.Ltibia_center(interval(i),1);
            py=Data.Ltibia_center(interval(i),2);
            pz=Data.Ltibia_center(interval(i),3);
            t=-(d + a*px + b*py + c*pz)/(a^2 + b^2 + c^2);
            
            Data.Lproj_femur(i,:)=[px+a*t py+b*t pz+c*t];
            Data.Lproj_vec(i,:)=Data.Lproj_femur(i,:)-Data.Lfemur_center(interval(i),:);
            Data.diffL(i,:)=Data.Lproj_vec(i,:)-Data.Lproj_vec(1,:);
            
            xaxis=Data.LKNE_1(interval(i),:)-Data.Lfemur_center(interval(i),:);
            yaxis=cross(surfaceN,xaxis);
            if yaxis(2)<0
                yaxis=-yaxis;
            end
            xaxis=xaxis/norm(xaxis);
            yaxis=yaxis/norm(yaxis);
            
            Data.xcompL(i)=dot(Data.diffL(i,:),xaxis);  % x axis: post. <=> ant.
            Data.ycompL(i)=dot(Data.diffL(i,:),yaxis);  % y axis: medial <=> lateral
            
            waitbar(i/length(interval)*0.5,h)
        end
        Data.distL=sqrt(Data.ycompL.^2+Data.xcompL.^2);
    end
    
    if length(Data.RSPtime)==2
        interval=[Data.RSPtime(1):Data.RSPtime(2)];
        for i=1:length(interval)
            %%% for right
            %%% calculate the distance between the center of mass (on femur plane) and the projection point of the center of mass (on tibia
            %%% plane) on the femur plane
            surfaceN=cross(Data.RTHI_3(interval(i),:)-Data.RKNE_1(interval(i),:),Data.RKNE_4(interval(i),:)-Data.RKNE_1(interval(i),:));  % cross to decide the normal of surface
            % surface equation: a(x-x0)+b(y-y0)+c(z-z0)=0; => ax+by+cz+d=0,  d=-ax0-by0-cz0, (x0,y0,z0) is on the surface
            a=surfaceN(1); b=surfaceN(2); c=surfaceN(3);
            d=-a*Data.RKNE_1(interval(i),1)-b*Data.RKNE_1(interval(i),2)-c*Data.RKNE_1(interval(i),3);
            
            % calculate the projection point
            px=Data.Rtibia_center(interval(i),1);
            py=Data.Rtibia_center(interval(i),2);
            pz=Data.Rtibia_center(interval(i),3);
            t=-(d + a*px + b*py + c*pz)/(a^2 + b^2 + c^2);
            
            Data.Rproj_femur(i,:)=[px+a*t py+b*t pz+c*t];
            Data.Rproj_vec(i,:)=Data.Rproj_femur(i,:)-Data.Rfemur_center(interval(i),:);
            Data.diffR(i,:)=Data.Rproj_vec(i,:)-Data.Rproj_vec(1,:);
            
            xaxis=Data.RKNE_1(interval(i),:)-Data.Rfemur_center(interval(i),:);
            yaxis=cross(surfaceN,xaxis);
            if yaxis(2)<0
                yaxis=-yaxis;
            end
            xaxis=xaxis/norm(xaxis);
            yaxis=yaxis/norm(yaxis);
            
            Data.xcompR(i)=dot(Data.diffR(i,:),xaxis);   % x axis: post. <=> ant.
            Data.ycompR(i)=dot(Data.diffR(i,:),yaxis);   % y axis: medial <=> lateral
            
            waitbar(0.5+i/length(interval)*0.5,h)
        end
        Data.distR=sqrt(Data.ycompR.^2+Data.xcompR.^2);
    end
    
    axislim=[min([Data.ycompL Data.ycompR]) max([Data.ycompL Data.ycompR]) min([Data.xcompL Data.xcompR]) max([Data.xcompL Data.xcompR])];
    if sum(axislim)~=0
        axes(handle.fig2_axes1),
        line('xdata',axislim(1:2),'ydata',[0 0],'color','k');
        line('xdata',[0 0],'ydata',axislim(3:4),'color','k');
        axis(axislim)
        axes(handle.fig2_axes2)
        line('xdata',axislim(1:2),'ydata',[0 0],'color','k');
        line('xdata',[0 0],'ydata',axislim(3:4),'color','k');
        axis(axislim)
        
        axes(handle.fig2_axes3),
        axis([0 1 axislim(1:2)])
        axes(handle.fig2_axes4),
        axis([0 1 axislim(1:2)])
        axes(handle.fig2_axes5),
        axis([0 1 axislim(3:4)])
        axes(handle.fig2_axes6),
        axis([0 1 axislim(3:4)])
    end
    
    close(h)
    Data.display_check=1;
    
    File.select=get(handle.filelist,'value');
    File.filelist{File.select}=Data;
    
elseif strcmp(action,'display'),
    if Data.display_check==0
        MotionAna_UI('analyze')
    end
    %% display the results
    set(handle.largptL(1),'xdata',[],'ydata',[],'color','r','marker','o','linestyle','none','linewidth',2)
    set(handle.largptR(1),'xdata',[],'ydata',[],'color','r','marker','o','linestyle','none','linewidth',2)
    set(handle.trajact(1),'xdata',[],'ydata',[],'color','b','marker','.','linestyle','-')
    set(handle.trajact(2),'xdata',[],'ydata',[],'color','b','marker','.','linestyle','-')
    set(handle.largptL(:),'xdata',[],'ydata',[])
    set(handle.largptR(:),'xdata',[],'ydata',[])
    set(handle.GshiftxL,'xdata',[],'ydata',[])
    set(handle.GshiftxR,'xdata',[],'ydata',[])
    set(handle.GshiftyL,'xdata',[],'ydata',[])
    set(handle.GshiftyR,'xdata',[],'ydata',[])
    set(handle.Lshifty,'xdata',[],'ydata',[])
    set(handle.Lshiftx,'xdata',[],'ydata',[])
    set(handle.Rshifty,'xdata',[],'ydata',[])
    set(handle.Rshiftx,'xdata',[],'ydata',[])
    set(handle.Langle,'xdata',[],'ydata',[])
    set(handle.Rangle,'xdata',[],'ydata',[])
    set(handle.Langvel,'xdata',[],'ydata',[])
    set(handle.Rangvel,'xdata',[],'ydata',[])
    set(handle.Langacc,'xdata',[],'ydata',[])
    set(handle.Rangacc,'xdata',[],'ydata',[])
    set(handle.GLangle(:),'xdata',[],'ydata',[])
    set(handle.GRangle(:),'xdata',[],'ydata',[])
    set(handle.GLangvel(:),'xdata',[],'ydata',[])
    set(handle.GRangvel(:),'xdata',[],'ydata',[])
    set(handle.GLangacc(:),'xdata',[],'ydata',[])
    set(handle.GRangacc(:),'xdata',[],'ydata',[])
    set(handle.textpL(1),'string','')
    set(handle.textpL(2),'string','')
    set(handle.textpL(3),'string','')
    set(handle.textpL(4),'string','')
    set(handle.textpR(1),'string','')
    set(handle.textpR(2),'string','')
    set(handle.textpR(3),'string','')
    set(handle.textpR(4),'string','')
    for i=1:size(Data.dataL,1)
        set(handle.projL(1),'xdata',[],'ydata',[],'zdata',[],'color','r','marker','x','linestyle','none','markersize',20)
        set(handle.projR(1),'xdata',[],'ydata',[],'zdata',[],'color','r','marker','x','linestyle','none','markersize',20)
        %%% display
        set(handle.lineL(1),'xdata',[Data.LKNE_1(i,1) Data.LTHI_3(i,1) Data.LKNE_4(i,1) Data.LKNE_1(i,1)],...
            'ydata',[Data.LKNE_1(i,2) Data.LTHI_3(i,2) Data.LKNE_4(i,2) Data.LKNE_1(i,2)],...
            'zdata',[Data.LKNE_1(i,3) Data.LTHI_3(i,3) Data.LKNE_4(i,3) Data.LKNE_1(i,3)],'color','r','marker','.','linestyle','-','markersize',14)
        set(handle.lineL(2),'xdata',[Data.LANK_6(i,1) Data.LTIB_2(i,1) Data.LTIB_5(i,1) Data.LANK_6(i,1)],...
            'ydata',[Data.LANK_6(i,2) Data.LTIB_2(i,2) Data.LTIB_5(i,2) Data.LANK_6(i,2)],...
            'zdata',[Data.LANK_6(i,3) Data.LTIB_2(i,3) Data.LTIB_5(i,3) Data.LANK_6(i,3)],'color','b','marker','.','linestyle','-','markersize',14)
        set(handle.centerL(1),'xdata',[Data.Lfemur_center(i,1)],...
            'ydata',[Data.Lfemur_center(i,2)],...
            'zdata',[Data.Lfemur_center(i,3)],'color','r','marker','^','linestyle','none','markersize',5,'markerfacecolor','r')
        set(handle.centerL(2),'xdata',[Data.Ltibia_center(i,1)],...
            'ydata',[Data.Ltibia_center(i,2)],...
            'zdata',[Data.Ltibia_center(i,3)],'color','b','marker','^','linestyle','none','markersize',5,'markerfacecolor','b')
        set(handle.lineL(3),'xdata',[Data.Ltibia_center(i,1) (0.75*Data.Lheel(i,1)+0.25*Data.Ltoe(i,1))],...
            'ydata',[Data.Ltibia_center(i,2) (0.75*Data.Lheel(i,2)+0.25*Data.Ltoe(i,2))],...
            'zdata',[Data.Ltibia_center(i,3) (0.75*Data.Lheel(i,3)+0.25*Data.Ltoe(i,3))],'color','k','marker','none','linestyle','-','markersize',10,'markerfacecolor','k','linewidth',2)
        set(handle.lineL(4),'xdata',[Data.Lheel(i,1) Data.Ltoe(i,1)],...
            'ydata',[Data.Lheel(i,2) Data.Ltoe(i,2)],...
            'zdata',[Data.Lheel(i,3) Data.Ltoe(i,3)],'color','k','marker','^','linestyle','-','markersize',10,'markerfacecolor','k','linewidth',2)
        
        set(handle.lineR(1),'xdata',[Data.RKNE_1(i,1) Data.RTHI_3(i,1) Data.RKNE_4(i,1) Data.RKNE_1(i,1)],...
            'ydata',[Data.RKNE_1(i,2) Data.RTHI_3(i,2) Data.RKNE_4(i,2) Data.RKNE_1(i,2)],...
            'zdata',[Data.RKNE_1(i,3) Data.RTHI_3(i,3) Data.RKNE_4(i,3) Data.RKNE_1(i,3)],'color','r','marker','.','linestyle','-','markersize',14)
        set(handle.lineR(2),'xdata',[Data.RANK_6(i,1) Data.RTIB_2(i,1) Data.RTIB_5(i,1) Data.RANK_6(i,1)],...
            'ydata',[Data.RANK_6(i,2) Data.RTIB_2(i,2) Data.RTIB_5(i,2) Data.RANK_6(i,2)],...
            'zdata',[Data.RANK_6(i,3) Data.RTIB_2(i,3) Data.RTIB_5(i,3) Data.RANK_6(i,3)],'color','b','marker','.','linestyle','-','markersize',14)
        set(handle.centerR(1),'xdata',[Data.Rfemur_center(i,1)],...
            'ydata',[Data.Rfemur_center(i,2)],...
            'zdata',[Data.Rfemur_center(i,3)],'color','r','marker','^','linestyle','none','markersize',5,'markerfacecolor','r')
        set(handle.centerR(2),'xdata',[Data.Rtibia_center(i,1)],...
            'ydata',[Data.Rtibia_center(i,2)],...
            'zdata',[Data.Rtibia_center(i,3)],'color','b','marker','^','linestyle','none','markersize',5,'markerfacecolor','b')
        set(handle.lineR(3),'xdata',[Data.Rtibia_center(i,1) (0.75*Data.Rheel(i,1)+0.25*Data.Rtoe(i,1))],...
            'ydata',[Data.Rtibia_center(i,2) (0.75*Data.Rheel(i,2)+0.25*Data.Rtoe(i,2))],...
            'zdata',[Data.Rtibia_center(i,3) (0.75*Data.Rheel(i,3)+0.25*Data.Rtoe(i,3))],'color','k','marker','none','linestyle','-','markersize',10,'markerfacecolor','k','linewidth',2)
        set(handle.lineR(4),'xdata',[Data.Rheel(i,1) Data.Rtoe(i,1)],...
            'ydata',[Data.Rheel(i,2) Data.Rtoe(i,2)],...
            'zdata',[Data.Rheel(i,3) Data.Rtoe(i,3)],'color','k','marker','^','linestyle','-','markersize',10,'markerfacecolor','k','linewidth',2)
        
        set(handle.lineLHT(1),'xdata',1:i,'ydata',Data.Lheel(1:i,3),'color','b','marker','.','linestyle','-')
        set(handle.lineLHT(2),'xdata',1:i,'ydata',Data.Ltoe(1:i,3),'color','r','marker','.','linestyle','-')
        
        set(handle.lineRHT(1),'xdata',1:i,'ydata',Data.Rheel(1:i,3),'color','b','marker','.','linestyle','-')
        set(handle.lineRHT(2),'xdata',1:i,'ydata',Data.Rtoe(1:i,3),'color','r','marker','.','linestyle','-')
        
        if ~isempty(Data.LSPtime)
            if ismember(i,[Data.LSPtime(1):Data.LSPtime(2)])
                interval=[Data.LSPtime(1):Data.LSPtime(2)];
                ind=find(interval==i);
                interval=(interval-min(interval))/(max(interval)-min(interval));
                set(handle.projL(1),'xdata',[Data.Lproj_femur(ind,1)],...
                    'ydata',[Data.Lproj_femur(ind,2)],...
                    'zdata',[Data.Lproj_femur(ind,3)],'color','r','marker','x','linestyle','none','markersize',20)
                set(handle.trajact(1),'xdata',Data.ycompL(1:ind),'ydata',Data.xcompL(1:ind),'color','b','marker','.','linestyle','-')
                set(handle.Lshifty,'xdata',interval(1:ind),'ydata',Data.ycompL(1:ind),'color','b','marker','.','linestyle','-')
                set(handle.Lshiftx,'xdata',interval(1:ind),'ydata',Data.xcompL(1:ind),'color','b','marker','.','linestyle','-')
                set(handle.Langle,'xdata',interval(1:ind),'ydata',Data.LKneeAY(Data.LSPtime(1):i),'color','b','marker','.','linestyle','-')
                set(handle.Langvel,'xdata',interval(1:ind),'ydata',Data.LKneeV(Data.LSPtime(1):i),'color','b','marker','.','linestyle','-')
                set(handle.Langacc,'xdata',interval(1:ind),'ydata',Data.LKneeAc(Data.LSPtime(1):i),'color','b','marker','.','linestyle','-')
            end
        end
        if ~isempty(Data.RSPtime)
            if ismember(i,[Data.RSPtime(1):Data.RSPtime(2)])
                interval=[Data.RSPtime(1):Data.RSPtime(2)];
                ind=find(interval==i);
                interval=(interval-min(interval))/(max(interval)-min(interval)); 
                set(handle.projR(1),'xdata',[Data.Rproj_femur(ind,1)],...
                    'ydata',[Data.Rproj_femur(ind,2)],...
                    'zdata',[Data.Rproj_femur(ind,3)],'color','r','marker','x','linestyle','none','markersize',20)
                set(handle.trajact(2),'xdata',Data.ycompR(1:ind),'ydata',Data.xcompR(1:ind),'color','b','marker','.','linestyle','-')
                set(handle.Rshifty,'xdata',interval(1:ind),'ydata',Data.ycompR(1:ind),'color','b','marker','.','linestyle','-')
                set(handle.Rshiftx,'xdata',interval(1:ind),'ydata',Data.xcompR(1:ind),'color','b','marker','.','linestyle','-')
                set(handle.Rangle,'xdata',interval(1:ind),'ydata',Data.RKneeAY(Data.RSPtime(1):i),'color','b','marker','.','linestyle','-')
                set(handle.Rangvel,'xdata',interval(1:ind),'ydata',Data.RKneeV(Data.RSPtime(1):i),'color','b','marker','.','linestyle','-')
                set(handle.Rangacc,'xdata',interval(1:ind),'ydata',Data.RKneeAc(Data.RSPtime(1):i),'color','b','marker','.','linestyle','-')
            end
        end
        
        Data.timept=i;
        set(handle.timeaxisL,'value',Data.timept)
        set(handle.timeaxisR,'value',Data.timept)
        set(handle.timetext,'string',[num2str(Data.timept) '/' num2str(size(Data.dataL,1))])
        
        pause(1/Data.samplerate)
        
    end
    axislim=[min([Data.ycompL Data.ycompR]) max([Data.ycompL Data.ycompR]) min([Data.xcompL Data.xcompR]) max([Data.xcompL Data.xcompR])];
    if ~isempty(Data.LSPtime)
        intervalL=[Data.LSPtime(1):(Data.LSPtime(1)+round(Data.LSPtime(2)-Data.LSPtime(1))*0.3)];
        indyL=find(abs(Data.ycompL(1:length(intervalL)))==max(abs(Data.ycompL(1:length(intervalL)))));
        indxL=find(abs(Data.xcompL(1:length(intervalL)))==max(abs(Data.xcompL(1:length(intervalL)))));
        
        intervalL=[Data.LSPtime(1):Data.LSPtime(2)];
        intervalL=(intervalL-min(intervalL))/(max(intervalL)-min(intervalL));
        set(handle.GshiftyL,'xdata',intervalL(indyL),'ydata',Data.ycompL(indyL),'color','r','marker','o','linestyle','none','linewidth',2)
        axes(handle.fig2_axes3),title(['Largest = ' num2str(Data.ycompL(indyL)) ' at time ' num2str(intervalL(indyL))])
        set(handle.GshiftxL,'xdata',intervalL(indxL),'ydata',Data.xcompL(indxL),'color',[1 0 1],'marker','o','linestyle','none','linewidth',2)
        axes(handle.fig2_axes5),title(['Largest = ' num2str(Data.xcompL(indxL)) ' at time ' num2str(intervalL(indxL))])
        
        interval=[Data.LSPtime(1):(Data.LSPtime(1)+round(Data.LSPtime(2)-Data.LSPtime(1))*0.3)];
        indmax=find(Data.LKneeAY(interval)==max(Data.LKneeAY(interval)));
        indmin=find(Data.LKneeAY(interval)==min(Data.LKneeAY(interval)));
        set(handle.GLangle(1),'xdata',intervalL(indmax),'ydata',Data.LKneeAY(interval(indmax)),'color','r','marker','o','linestyle','none','linewidth',2)
        set(handle.GLangle(2),'xdata',intervalL(indmin),'ydata',Data.LKneeAY(interval(indmin)),'color',[1 0 1],'marker','o','linestyle','none','linewidth',2)
        axes(handle.fig2_axes7),title(['Max: ' num2str(Data.LKneeAY(interval(indmax))) ' at ' num2str(intervalL(indmax)) ', Min: ' num2str(Data.LKneeAY(interval(indmin))) ' at ' num2str(intervalL(indmin))])
        
        indmax=find(Data.LKneeV(interval)==max(Data.LKneeV(interval)));
        indmin=find(Data.LKneeV(interval)==min(Data.LKneeV(interval)));
        set(handle.GLangvel(1),'xdata',intervalL(indmax),'ydata',Data.LKneeV(interval(indmax)),'color','r','marker','o','linestyle','none','linewidth',2)
        set(handle.GLangvel(2),'xdata',intervalL(indmin),'ydata',Data.LKneeV(interval(indmin)),'color',[1 0 1],'marker','o','linestyle','none','linewidth',2)
        axes(handle.fig2_axes9),title(['Max: ' num2str(Data.LKneeV(interval(indmax))) ' at ' num2str(intervalL(indmax)) ', Min: ' num2str(Data.LKneeV(interval(indmin))) ' at ' num2str(intervalL(indmin))])
        
        indmax=find(Data.LKneeAc(interval)==max(Data.LKneeAc(interval)));
        indmin=find(Data.LKneeAc(interval)==min(Data.LKneeAc(interval)));
        set(handle.GLangacc(1),'xdata',intervalL(indmax),'ydata',Data.LKneeAc(interval(indmax)),'color','r','marker','o','linestyle','none','linewidth',2)
        set(handle.GLangacc(2),'xdata',intervalL(indmin),'ydata',Data.LKneeAc(interval(indmin)),'color',[1 0 1],'marker','o','linestyle','none','linewidth',2)
        axes(handle.fig2_axes11),title(['Max: ' num2str(Data.LKneeAc(interval(indmax))) ' at ' num2str(intervalL(indmax)) ', Min: ' num2str(Data.LKneeAc(interval(indmin))) ' at ' num2str(intervalL(indmin))])
        
        set(handle.largptL(1),'xdata',Data.ycompL(indyL),'ydata',Data.xcompL(indyL),'color','r','marker','o','linestyle','none','linewidth',2)
        set(handle.largptL(2),'xdata',Data.ycompL(indxL),'ydata',Data.xcompL(indxL),'color',[1 0 1],'marker','o','linestyle','none','linewidth',2)
        tmp=length(find(Data.xcompL>0 & Data.ycompL<0));
        set(handle.textpL(1),'position',[axislim(1) axislim(4)-0.2],'string',sprintf('%2.1f',tmp/length(intervalL)*100),'color','r')
        tmp=length(find(Data.xcompL>0 & Data.ycompL>0));
        set(handle.textpL(2),'position',[axislim(2)+2 axislim(4)-0.2],'string',sprintf('%2.1f',tmp/length(intervalL)*100),'color','r')
        tmp=length(find(Data.xcompL<0 & Data.ycompL>0));
        set(handle.textpL(3),'position',[axislim(2)+2 axislim(3)],'string',sprintf('%2.1f',tmp/length(intervalL)*100),'color','r')
        tmp=length(find(Data.xcompL<0 & Data.ycompL<0));
        set(handle.textpL(4),'position',[axislim(1) axislim(3)],'string',sprintf('%2.1f',tmp/length(intervalL)*100),'color','r')
        axes(handle.fig2_axes1),title(['dist. = ' num2str(Data.distL(indyL)) '(red), dist. = ' num2str(Data.distL(indxL)) '(pink)'])        
    end
    if ~isempty(Data.RSPtime)
        intervalR=[Data.RSPtime(1):Data.RSPtime(1)+round(Data.RSPtime(2)-Data.RSPtime(1))*0.3];
        indyR=find(abs(Data.ycompR(1:length(intervalR)))==max(abs(Data.ycompR(1:length(intervalR)))));
        indxR=find(abs(Data.xcompR(1:length(intervalR)))==max(abs(Data.xcompR(1:length(intervalR)))));
        
        intervalR=[Data.RSPtime(1):Data.RSPtime(2)];
        intervalR=(intervalR-min(intervalR))/(max(intervalR)-min(intervalR));
        set(handle.GshiftyR,'xdata',intervalR(indyR),'ydata',Data.ycompR(indyR),'color','r','marker','o','linestyle','none','linewidth',2)
        axes(handle.fig2_axes4),title(['Largest = ' num2str(Data.ycompR(indyR)) ' at time ' num2str(intervalR(indyR))])
        set(handle.GshiftxR,'xdata',intervalR(indxR),'ydata',Data.xcompR(indxR),'color',[1 0 1],'marker','o','linestyle','none','linewidth',2)
        axes(handle.fig2_axes6),title(['Largest = ' num2str(Data.xcompR(indxR)) ' at time ' num2str(intervalR(indxR))])
        
        interval=[Data.RSPtime(1):Data.RSPtime(1)+round(Data.RSPtime(2)-Data.RSPtime(1))*0.3];
        indmax=find(Data.RKneeAY(interval)==max(Data.RKneeAY(interval)));
        indmin=find(Data.RKneeAY(interval)==min(Data.RKneeAY(interval)));
        set(handle.GRangle(1),'xdata',intervalR(indmax),'ydata',Data.RKneeAY(interval(indmax)),'color','r','marker','o','linestyle','none','linewidth',2)
        set(handle.GRangle(2),'xdata',intervalR(indmin),'ydata',Data.RKneeAY(interval(indmin)),'color',[1 0 1],'marker','o','linestyle','none','linewidth',2)
        axes(handle.fig2_axes8),title(['Max: ' num2str(Data.RKneeAY(interval(indmax))) ' at ' num2str(intervalR(indmax)) ', Min: ' num2str(Data.RKneeAY(interval(indmin))) ' at ' num2str(intervalR(indmin))])
        
        indmax=find(Data.RKneeV(interval)==max(Data.RKneeV(interval)));
        indmin=find(Data.RKneeV(interval)==min(Data.RKneeV(interval)));
        set(handle.GRangvel(1),'xdata',intervalR(indmax),'ydata',Data.RKneeV(interval(indmax)),'color','r','marker','o','linestyle','none','linewidth',2)
        set(handle.GRangvel(2),'xdata',intervalR(indmin),'ydata',Data.RKneeV(interval(indmin)),'color',[1 0 1],'marker','o','linestyle','none','linewidth',2)
        axes(handle.fig2_axes10),title(['Max: ' num2str(Data.RKneeV(interval(indmax))) ' at ' num2str(intervalR(indmax)) ', Min: ' num2str(Data.RKneeV(interval(indmin))) ' at ' num2str(intervalR(indmin))])
        
        indmax=find(Data.RKneeAc(interval)==max(Data.RKneeAc(interval)));
        indmin=find(Data.RKneeAc(interval)==min(Data.RKneeAc(interval)));
        set(handle.GRangacc(1),'xdata',intervalR(indmax),'ydata',Data.RKneeAc(interval(indmax)),'color','r','marker','o','linestyle','none','linewidth',2)
        set(handle.GRangacc(2),'xdata',intervalR(indmin),'ydata',Data.RKneeAc(interval(indmin)),'color',[1 0 1],'marker','o','linestyle','none','linewidth',2)
        axes(handle.fig2_axes12),title(['Max: ' num2str(Data.RKneeAc(interval(indmax))) ' at ' num2str(intervalR(indmax)) ', Min: ' num2str(Data.RKneeAc(interval(indmin))) ' at ' num2str(intervalR(indmin))])
        
        set(handle.largptR(1),'xdata',Data.ycompR(indyR),'ydata',Data.xcompR(indyR),'color','r','marker','o','linestyle','none','linewidth',2)
        set(handle.largptR(2),'xdata',Data.ycompR(indxR),'ydata',Data.xcompR(indxR),'color',[1 0 1],'marker','o','linestyle','none','linewidth',2)
        tmp=length(find(Data.xcompR>0 & Data.ycompR<0));
        set(handle.textpR(1),'position',[axislim(1) axislim(4)-1],'string',sprintf('%2.1f',tmp/length(intervalR)*100),'color','r')
        tmp=length(find(Data.xcompR>0 & Data.ycompR>0));
        set(handle.textpR(2),'position',[axislim(2)+2 axislim(4)-1],'string',sprintf('%2.1f',tmp/length(intervalR)*100),'color','r')
        tmp=length(find(Data.xcompR<0 & Data.ycompR>0));
        set(handle.textpR(3),'position',[axislim(2)+2 axislim(3)+1],'string',sprintf('%2.1f',tmp/length(intervalR)*100),'color','r')
        tmp=length(find(Data.xcompR<0 & Data.ycompR<0));
        set(handle.textpR(4),'position',[axislim(1) axislim(3)+1],'string',sprintf('%2.1f',tmp/length(intervalR)*100),'color','r')
        axes(handle.fig2_axes2),title(['dist. = ' num2str(Data.distR(indyR)) '(red), dist. = ' num2str(Data.distR(indxR)) '(pink)'])        
    end
    
elseif strcmp(action,'timeaxisL'),
    Data.timept=round(get(handle.timeaxisL,'value'));
    MotionAna_UI('timeaxis')
elseif strcmp(action,'timeaxisR'),
    Data.timept=round(get(handle.timeaxisR,'value'));
    MotionAna_UI('timeaxis')
elseif strcmp(action,'timeaxis'),
    if Data.display_check==0
        MotionAna_UI('analyze')
    end
    
    set(handle.timeaxisL,'value',Data.timept)
    set(handle.timeaxisR,'value',Data.timept)
    set(handle.timetext,'string',[num2str(Data.timept) '/' num2str(size(Data.dataL,1))])
    
    
    %% display the results
    set(handle.largptL(1),'xdata',[],'ydata',[],'color','r','marker','o','linestyle','none','linewidth',2)
    set(handle.largptR(1),'xdata',[],'ydata',[],'color','r','marker','o','linestyle','none','linewidth',2)
    set(handle.trajact(1),'xdata',[],'ydata',[],'color','b','marker','.','linestyle','-')
    set(handle.trajact(2),'xdata',[],'ydata',[],'color','b','marker','.','linestyle','-')
    i=Data.timept;
    set(handle.projL(1),'xdata',[],'ydata',[],'zdata',[],'color','r','marker','x','linestyle','none','markersize',20)
    set(handle.projR(1),'xdata',[],'ydata',[],'zdata',[],'color','r','marker','x','linestyle','none','markersize',20)
    %%% display
    set(handle.lineL(1),'xdata',[Data.LKNE_1(i,1) Data.LTHI_3(i,1) Data.LKNE_4(i,1) Data.LKNE_1(i,1)],...
        'ydata',[Data.LKNE_1(i,2) Data.LTHI_3(i,2) Data.LKNE_4(i,2) Data.LKNE_1(i,2)],...
        'zdata',[Data.LKNE_1(i,3) Data.LTHI_3(i,3) Data.LKNE_4(i,3) Data.LKNE_1(i,3)],'color','r','marker','.','linestyle','-','markersize',14)
    set(handle.lineL(2),'xdata',[Data.LANK_6(i,1) Data.LTIB_2(i,1) Data.LTIB_5(i,1) Data.LANK_6(i,1)],...
        'ydata',[Data.LANK_6(i,2) Data.LTIB_2(i,2) Data.LTIB_5(i,2) Data.LANK_6(i,2)],...
        'zdata',[Data.LANK_6(i,3) Data.LTIB_2(i,3) Data.LTIB_5(i,3) Data.LANK_6(i,3)],'color','b','marker','.','linestyle','-','markersize',14)
    set(handle.centerL(1),'xdata',[Data.Lfemur_center(i,1)],...
        'ydata',[Data.Lfemur_center(i,2)],...
        'zdata',[Data.Lfemur_center(i,3)],'color','r','marker','^','linestyle','none','markersize',5,'markerfacecolor','r')
    set(handle.centerL(2),'xdata',[Data.Ltibia_center(i,1)],...
        'ydata',[Data.Ltibia_center(i,2)],...
        'zdata',[Data.Ltibia_center(i,3)],'color','b','marker','^','linestyle','none','markersize',5,'markerfacecolor','b')
    set(handle.lineL(3),'xdata',[Data.Ltibia_center(i,1) (0.75*Data.Lheel(i,1)+0.25*Data.Ltoe(i,1))],...
        'ydata',[Data.Ltibia_center(i,2) (0.75*Data.Lheel(i,2)+0.25*Data.Ltoe(i,2))],...
        'zdata',[Data.Ltibia_center(i,3) (0.75*Data.Lheel(i,3)+0.25*Data.Ltoe(i,3))],'color','k','marker','none','linestyle','-','markersize',10,'markerfacecolor','k','linewidth',2)
    set(handle.lineL(4),'xdata',[Data.Lheel(i,1) Data.Ltoe(i,1)],...
        'ydata',[Data.Lheel(i,2) Data.Ltoe(i,2)],...
        'zdata',[Data.Lheel(i,3) Data.Ltoe(i,3)],'color','k','marker','^','linestyle','-','markersize',10,'markerfacecolor','k','linewidth',2)
    
    set(handle.lineR(1),'xdata',[Data.RKNE_1(i,1) Data.RTHI_3(i,1) Data.RKNE_4(i,1) Data.RKNE_1(i,1)],...
        'ydata',[Data.RKNE_1(i,2) Data.RTHI_3(i,2) Data.RKNE_4(i,2) Data.RKNE_1(i,2)],...
        'zdata',[Data.RKNE_1(i,3) Data.RTHI_3(i,3) Data.RKNE_4(i,3) Data.RKNE_1(i,3)],'color','r','marker','.','linestyle','-','markersize',14)
    set(handle.lineR(2),'xdata',[Data.RANK_6(i,1) Data.RTIB_2(i,1) Data.RTIB_5(i,1) Data.RANK_6(i,1)],...
        'ydata',[Data.RANK_6(i,2) Data.RTIB_2(i,2) Data.RTIB_5(i,2) Data.RANK_6(i,2)],...
        'zdata',[Data.RANK_6(i,3) Data.RTIB_2(i,3) Data.RTIB_5(i,3) Data.RANK_6(i,3)],'color','b','marker','.','linestyle','-','markersize',14)
    set(handle.centerR(1),'xdata',[Data.Rfemur_center(i,1)],...
        'ydata',[Data.Rfemur_center(i,2)],...
        'zdata',[Data.Rfemur_center(i,3)],'color','r','marker','^','linestyle','none','markersize',5,'markerfacecolor','r')
    set(handle.centerR(2),'xdata',[Data.Rtibia_center(i,1)],...
        'ydata',[Data.Rtibia_center(i,2)],...
        'zdata',[Data.Rtibia_center(i,3)],'color','b','marker','^','linestyle','none','markersize',5,'markerfacecolor','b')
    set(handle.lineR(3),'xdata',[Data.Rtibia_center(i,1) (0.75*Data.Rheel(i,1)+0.25*Data.Rtoe(i,1))],...
        'ydata',[Data.Rtibia_center(i,2) (0.75*Data.Rheel(i,2)+0.25*Data.Rtoe(i,2))],...
        'zdata',[Data.Rtibia_center(i,3) (0.75*Data.Rheel(i,3)+0.25*Data.Rtoe(i,3))],'color','k','marker','none','linestyle','-','markersize',10,'markerfacecolor','k','linewidth',2)
    set(handle.lineR(4),'xdata',[Data.Rheel(i,1) Data.Rtoe(i,1)],...
        'ydata',[Data.Rheel(i,2) Data.Rtoe(i,2)],...
        'zdata',[Data.Rheel(i,3) Data.Rtoe(i,3)],'color','k','marker','^','linestyle','-','markersize',10,'markerfacecolor','k','linewidth',2)
    
    set(handle.lineLHT(1),'xdata',1:i,'ydata',Data.Lheel(1:i,3),'color','b','marker','.','linestyle','-')
    set(handle.lineLHT(2),'xdata',1:i,'ydata',Data.Ltoe(1:i,3),'color','r','marker','.','linestyle','-')
    
    set(handle.lineRHT(1),'xdata',1:i,'ydata',Data.Rheel(1:i,3),'color','b','marker','.','linestyle','-')
    set(handle.lineRHT(2),'xdata',1:i,'ydata',Data.Rtoe(1:i,3),'color','r','marker','.','linestyle','-')
    
    if ~isempty(Data.LSPtime)
        interval=[Data.LSPtime(1):Data.LSPtime(2)];
        if ismember(i,[Data.LSPtime(1):Data.LSPtime(2)])
            ind=find(interval==i);
            interval=(interval-min(interval))/(max(interval)-min(interval)); 
            set(handle.projL(1),'xdata',[Data.Lproj_femur(ind,1)],...
                'ydata',[Data.Lproj_femur(ind,2)],...
                'zdata',[Data.Lproj_femur(ind,3)],'color','r','marker','x','linestyle','none','markersize',20)
            set(handle.trajact(1),'xdata',Data.ycompL(1:ind),'ydata',Data.xcompL(1:ind),'color','b','marker','.','linestyle','-')
            set(handle.Lshifty,'xdata',interval(1:ind),'ydata',Data.ycompL(1:ind),'color','b','marker','.','linestyle','-')
            set(handle.Lshiftx,'xdata',interval(1:ind),'ydata',Data.xcompL(1:ind),'color','b','marker','.','linestyle','-')
            set(handle.Langle,'xdata',interval(1:ind),'ydata',Data.LKneeAY(Data.LSPtime(1):i),'color','b','marker','.','linestyle','-')
            set(handle.Langvel,'xdata',interval(1:ind),'ydata',Data.LKneeV(Data.LSPtime(1):i),'color','b','marker','.','linestyle','-')
            set(handle.Langacc,'xdata',interval(1:ind),'ydata',Data.LKneeAc(Data.LSPtime(1):i),'color','b','marker','.','linestyle','-')
        elseif i>Data.LSPtime(2)
            interval=(interval-min(interval))/(max(interval)-min(interval)); 
            set(handle.trajact(1),'xdata',Data.ycompL,'ydata',Data.xcompL,'color','b','marker','.','linestyle','-')
            set(handle.Lshifty,'xdata',interval,'ydata',Data.ycompL,'color','b','marker','.','linestyle','-')
            set(handle.Lshiftx,'xdata',interval,'ydata',Data.xcompL,'color','b','marker','.','linestyle','-')
            set(handle.Langle,'xdata',interval,'ydata',Data.LKneeAY(Data.LSPtime(1):Data.LSPtime(2)),'color','b','marker','.','linestyle','-')
            set(handle.Langvel,'xdata',interval,'ydata',Data.LKneeV(Data.LSPtime(1):Data.LSPtime(2)),'color','b','marker','.','linestyle','-')
            set(handle.Langacc,'xdata',interval,'ydata',Data.LKneeAc(Data.LSPtime(1):Data.LSPtime(2)),'color','b','marker','.','linestyle','-')
        elseif i<Data.LSPtime(1)
            set(handle.trajact(1),'xdata',[],'ydata',[])
            set(handle.Lshifty,'xdata',[],'ydata',[])
            set(handle.Lshiftx,'xdata',[],'ydata',[])
            set(handle.Langle,'xdata',[],'ydata',[])
            set(handle.Langvel,'xdata',[],'ydata',[])
            set(handle.Langacc,'xdata',[],'ydata',[])
        end
    end
    if ~isempty(Data.RSPtime)
        interval=[Data.RSPtime(1):Data.RSPtime(2)];
        if ismember(i,[Data.RSPtime(1):Data.RSPtime(2)])
            ind=find(interval==i);
            interval=(interval-min(interval))/(max(interval)-min(interval)); 
            set(handle.projR(1),'xdata',[Data.Rproj_femur(ind,1)],...
                'ydata',[Data.Rproj_femur(ind,2)],...
                'zdata',[Data.Rproj_femur(ind,3)],'color','r','marker','x','linestyle','none','markersize',20)
            set(handle.trajact(2),'xdata',Data.ycompR(1:ind),'ydata',Data.xcompR(1:ind),'color','b','marker','.','linestyle','-')
            set(handle.Rshifty,'xdata',interval(1:ind),'ydata',Data.ycompR(1:ind),'color','b','marker','.','linestyle','-')
            set(handle.Rshiftx,'xdata',interval(1:ind),'ydata',Data.xcompR(1:ind),'color','b','marker','.','linestyle','-')
            set(handle.Rangle,'xdata',interval(1:ind),'ydata',Data.RKneeAY(Data.RSPtime(1):i),'color','b','marker','.','linestyle','-')
            set(handle.Rangvel,'xdata',interval(1:ind),'ydata',Data.RKneeV(Data.RSPtime(1):i),'color','b','marker','.','linestyle','-')
            set(handle.Rangacc,'xdata',interval(1:ind),'ydata',Data.RKneeAc(Data.RSPtime(1):i),'color','b','marker','.','linestyle','-')
        elseif i>Data.RSPtime(2)
            interval=(interval-min(interval))/(max(interval)-min(interval)); 
            set(handle.trajact(2),'xdata',Data.ycompR,'ydata',Data.xcompR,'color','b','marker','.','linestyle','-')
            set(handle.Rshifty,'xdata',interval,'ydata',Data.ycompR,'color','b','marker','.','linestyle','-')
            set(handle.Rshiftx,'xdata',interval,'ydata',Data.xcompR,'color','b','marker','.','linestyle','-')
            set(handle.Rangle,'xdata',interval,'ydata',Data.RKneeAY(Data.RSPtime(1):Data.RSPtime(2)),'color','b','marker','.','linestyle','-')
            set(handle.Rangvel,'xdata',interval,'ydata',Data.RKneeV(Data.RSPtime(1):Data.RSPtime(2)),'color','b','marker','.','linestyle','-')
            set(handle.Rangacc,'xdata',interval,'ydata',Data.RKneeAc(Data.RSPtime(1):Data.RSPtime(2)),'color','b','marker','.','linestyle','-')
        elseif i<Data.RSPtime(1)
            set(handle.trajact(2),'xdata',[],'ydata',[])
            set(handle.Rshifty,'xdata',[],'ydata',[])
            set(handle.Rshiftx,'xdata',[],'ydata',[])
            set(handle.Rangle,'xdata',[],'ydata',[])
            set(handle.Rangvel,'xdata',[],'ydata',[])
            set(handle.Rangacc,'xdata',[],'ydata',[])    
        end
    end
    
    axislim=[min([Data.ycompL Data.ycompR]) max([Data.ycompL Data.ycompR]) min([Data.xcompL Data.xcompR]) max([Data.xcompL Data.xcompR])];
    if ~isempty(Data.LSPtime)
        intervalL=[Data.LSPtime(1):(Data.LSPtime(1)+round(Data.LSPtime(2)-Data.LSPtime(1))*0.3)];
        indyL=find(abs(Data.ycompL(1:length(intervalL)))==max(abs(Data.ycompL(1:length(intervalL)))));
        indxL=find(abs(Data.xcompL(1:length(intervalL)))==max(abs(Data.xcompL(1:length(intervalL)))));
        
        intervalL=[Data.LSPtime(1):Data.LSPtime(2)];
        intervalL=(intervalL-min(intervalL))/(max(intervalL)-min(intervalL)); 
        set(handle.GshiftyL,'xdata',intervalL(indyL),'ydata',Data.ycompL(indyL),'color','r','marker','o','linestyle','none','linewidth',2)
        axes(handle.fig2_axes3),title(['Largest = ' num2str(Data.ycompL(indyL)) ' at time ' num2str(intervalL(indyL))])
        set(handle.GshiftxL,'xdata',intervalL(indxL),'ydata',Data.xcompL(indxL),'color',[1 0 1],'marker','o','linestyle','none','linewidth',2)
        axes(handle.fig2_axes5),title(['Largest = ' num2str(Data.xcompL(indxL)) ' at time ' num2str(intervalL(indxL))])
        
        interval=[Data.LSPtime(1):(Data.LSPtime(1)+round(Data.LSPtime(2)-Data.LSPtime(1))*0.3)];
        indmax=find(Data.LKneeAY(interval)==max(Data.LKneeAY(interval)));
        indmin=find(Data.LKneeAY(interval)==min(Data.LKneeAY(interval)));
        set(handle.GLangle(1),'xdata',intervalL(indmax),'ydata',Data.LKneeAY(interval(indmax)),'color','r','marker','o','linestyle','none','linewidth',2)
        set(handle.GLangle(2),'xdata',intervalL(indmin),'ydata',Data.LKneeAY(interval(indmin)),'color',[1 0 1],'marker','o','linestyle','none','linewidth',2)
        axes(handle.fig2_axes7),title(['Max: ' num2str(Data.LKneeAY(interval(indmax))) ' at ' num2str(intervalL(indmax)) ', Min: ' num2str(Data.LKneeAY(interval(indmin))) ' at ' num2str(intervalL(indmin))])
        
        indmax=find(Data.LKneeV(interval)==max(Data.LKneeV(interval)));
        indmin=find(Data.LKneeV(interval)==min(Data.LKneeV(interval)));
        set(handle.GLangvel(1),'xdata',intervalL(indmax),'ydata',Data.LKneeV(interval(indmax)),'color','r','marker','o','linestyle','none','linewidth',2)
        set(handle.GLangvel(2),'xdata',intervalL(indmin),'ydata',Data.LKneeV(interval(indmin)),'color',[1 0 1],'marker','o','linestyle','none','linewidth',2)
        axes(handle.fig2_axes9),title(['Max: ' num2str(Data.LKneeV(interval(indmax))) ' at ' num2str(intervalL(indmax)) ', Min: ' num2str(Data.LKneeV(interval(indmin))) ' at ' num2str(intervalL(indmin))])
        
        indmax=find(Data.LKneeAc(interval)==max(Data.LKneeAc(interval)));
        indmin=find(Data.LKneeAc(interval)==min(Data.LKneeAc(interval)));
        set(handle.GLangacc(1),'xdata',intervalL(indmax),'ydata',Data.LKneeAc(interval(indmax)),'color','r','marker','o','linestyle','none','linewidth',2)
        set(handle.GLangacc(2),'xdata',intervalL(indmin),'ydata',Data.LKneeAc(interval(indmin)),'color',[1 0 1],'marker','o','linestyle','none','linewidth',2)
        axes(handle.fig2_axes11),title(['Max: ' num2str(Data.LKneeAc(interval(indmax))) ' at ' num2str(intervalL(indmax)) ', Min: ' num2str(Data.LKneeAc(interval(indmin))) ' at ' num2str(intervalL(indmin))])
        
        set(handle.largptL(1),'xdata',Data.ycompL(indyL),'ydata',Data.xcompL(indyL),'color','r','marker','o','linestyle','none','linewidth',2)
        set(handle.largptL(2),'xdata',Data.ycompL(indxL),'ydata',Data.xcompL(indxL),'color',[1 0 1],'marker','o','linestyle','none','linewidth',2)
        tmp=length(find(Data.xcompL>0 & Data.ycompL<0));
        set(handle.textpL(1),'position',[axislim(1) axislim(4)-0.2],'string',sprintf('%2.1f',tmp/length(intervalL)*100),'color','r')
        tmp=length(find(Data.xcompL>0 & Data.ycompL>0));
        set(handle.textpL(2),'position',[axislim(2)+2 axislim(4)-0.2],'string',sprintf('%2.1f',tmp/length(intervalL)*100),'color','r')
        tmp=length(find(Data.xcompL<0 & Data.ycompL>0));
        set(handle.textpL(3),'position',[axislim(2)+2 axislim(3)],'string',sprintf('%2.1f',tmp/length(intervalL)*100),'color','r')
        tmp=length(find(Data.xcompL<0 & Data.ycompL<0));
        set(handle.textpL(4),'position',[axislim(1) axislim(3)],'string',sprintf('%2.1f',tmp/length(intervalL)*100),'color','r')
        axes(handle.fig2_axes1),title(['dist. = ' num2str(Data.distL(indyL)) '(red), dist. = ' num2str(Data.distL(indxL)) '(pink)'])        
    end
    if ~isempty(Data.RSPtime)
        intervalR=[Data.RSPtime(1):(Data.RSPtime(1)+round(Data.RSPtime(2)-Data.RSPtime(1))*0.3)];
        indyR=find(abs(Data.ycompR(1:length(intervalR)))==max(abs(Data.ycompR(1:length(intervalR)))));
        indxR=find(abs(Data.xcompR(1:length(intervalR)))==max(abs(Data.xcompR(1:length(intervalR)))));
        
        intervalR=[Data.RSPtime(1):Data.RSPtime(2)];
        intervalR=(intervalR-min(intervalR))/(max(intervalR)-min(intervalR)); 
        set(handle.GshiftyR,'xdata',intervalR(indyR),'ydata',Data.ycompR(indyR),'color','r','marker','o','linestyle','none','linewidth',2)
        axes(handle.fig2_axes4),title(['Largest = ' num2str(Data.ycompR(indyR)) ' at time ' num2str(intervalR(indyR))])
        set(handle.GshiftxR,'xdata',intervalR(indxR),'ydata',Data.xcompR(indxR),'color',[1 0 1],'marker','o','linestyle','none','linewidth',2)
        axes(handle.fig2_axes6),title(['Largest = ' num2str(Data.xcompR(indxR)) ' at time ' num2str(intervalR(indxR))])
        
        interval=[Data.RSPtime(1):(Data.RSPtime(1)+round(Data.RSPtime(2)-Data.RSPtime(1))*0.3)];
        indmax=find(Data.RKneeAY(interval)==max(Data.RKneeAY(interval)));
        indmin=find(Data.RKneeAY(interval)==min(Data.RKneeAY(interval)));
        set(handle.GRangle(1),'xdata',intervalR(indmax),'ydata',Data.RKneeAY(interval(indmax)),'color','r','marker','o','linestyle','none','linewidth',2)
        set(handle.GRangle(2),'xdata',intervalR(indmin),'ydata',Data.RKneeAY(interval(indmin)),'color',[1 0 1],'marker','o','linestyle','none','linewidth',2)
        axes(handle.fig2_axes8),title(['Max: ' num2str(Data.RKneeAY(interval(indmax))) ' at ' num2str(intervalR(indmax)) ', Min: ' num2str(Data.RKneeAY(interval(indmin))) ' at ' num2str(intervalR(indmin))])
        
        indmax=find(Data.RKneeV(interval)==max(Data.RKneeV(interval)));
        indmin=find(Data.RKneeV(interval)==min(Data.RKneeV(interval)));
        set(handle.GRangvel(1),'xdata',intervalR(indmax),'ydata',Data.RKneeV(interval(indmax)),'color','r','marker','o','linestyle','none','linewidth',2)
        set(handle.GRangvel(2),'xdata',intervalR(indmin),'ydata',Data.RKneeV(interval(indmin)),'color',[1 0 1],'marker','o','linestyle','none','linewidth',2)
        axes(handle.fig2_axes10),title(['Max: ' num2str(Data.RKneeV(interval(indmax))) ' at ' num2str(intervalR(indmax)) ', Min: ' num2str(Data.RKneeV(interval(indmin))) ' at ' num2str(intervalR(indmin))])
        
        indmax=find(Data.RKneeAc(interval)==max(Data.RKneeAc(interval)));
        indmin=find(Data.RKneeAc(interval)==min(Data.RKneeAc(interval)));
        set(handle.GRangacc(1),'xdata',intervalR(indmax),'ydata',Data.RKneeAc(interval(indmax)),'color','r','marker','o','linestyle','none','linewidth',2)
        set(handle.GRangacc(2),'xdata',intervalR(indmin),'ydata',Data.RKneeAc(interval(indmin)),'color',[1 0 1],'marker','o','linestyle','none','linewidth',2)
        axes(handle.fig2_axes12),title(['Max: ' num2str(Data.RKneeAc(interval(indmax))) ' at ' num2str(intervalR(indmax)) ', Min: ' num2str(Data.RKneeAc(interval(indmin))) ' at ' num2str(intervalR(indmin))])
        
        set(handle.largptR(1),'xdata',Data.ycompR(indyR),'ydata',Data.xcompR(indyR),'color','r','marker','o','linestyle','none','linewidth',2)
        set(handle.largptR(2),'xdata',Data.ycompR(indxR),'ydata',Data.xcompR(indxR),'color',[1 0 1],'marker','o','linestyle','none','linewidth',2)
        tmp=length(find(Data.xcompR>0 & Data.ycompR<0));
        set(handle.textpR(1),'position',[axislim(1) axislim(4)-1],'string',sprintf('%2.1f',tmp/length(intervalR)*100),'color','r')
        tmp=length(find(Data.xcompR>0 & Data.ycompR>0));
        set(handle.textpR(2),'position',[axislim(2)+2 axislim(4)-1],'string',sprintf('%2.1f',tmp/length(intervalR)*100),'color','r')
        tmp=length(find(Data.xcompR<0 & Data.ycompR>0));
        set(handle.textpR(3),'position',[axislim(2)+2 axislim(3)+1],'string',sprintf('%2.1f',tmp/length(intervalR)*100),'color','r')
        tmp=length(find(Data.xcompR<0 & Data.ycompR<0));
        set(handle.textpR(4),'position',[axislim(1) axislim(3)+1],'string',sprintf('%2.1f',tmp/length(intervalR)*100),'color','r')
        axes(handle.fig2_axes2),title(['dist. = ' num2str(Data.distR(indyR)) '(red), dist. = ' num2str(Data.distR(indxR)) '(pink)'])        
    end
    
elseif strcmp(action,'export'),
    if Data.display_check==0
        MotionAna_UI('analyze')
    end    
    
    if ~isempty(Data.LSPtime)
        savearray={};
        savearray=[{'LSP(%)'},{'Lxcomp'},{'Lycomp'},{'Ldist'},{'LAngle'},{'LAng.Vel.'},{'LAng.Accel.'},{''},{'Left'},{'%'},{''},{'RSP(%)'},{'Rxcomp'},{'Rycomp'},{'Rdist'},{'RAngle'},{'RAng.Vel.'},{'RAng.Accel.'},{''},{'Right'},{'%'}];
        savearray(2,9)={'AntMed'};
        savearray(3,9)={'AntLat'};
        savearray(4,9)={'PostLat'};
        savearray(5,9)={'PostMed'};      
        savearray(2,20)={'AntMed'};
        savearray(3,20)={'AntLat'};
        savearray(4,20)={'PostLat'};
        savearray(5,20)={'PostMed'};  
        interval=[Data.LSPtime(1):Data.LSPtime(2)];
        tmp=length(find(Data.xcompL>0 & Data.ycompL<0));
        savearray(2,10)={sprintf('%2.1f',tmp/length(interval)*100)};
        tmp=length(find(Data.xcompL>0 & Data.ycompL>0));
        savearray(3,10)={sprintf('%2.1f',tmp/length(interval)*100)};
        tmp=length(find(Data.xcompL<0 & Data.ycompL>0));
        savearray(4,10)={sprintf('%2.1f',tmp/length(interval)*100)};
        tmp=length(find(Data.xcompL<0 & Data.ycompL<0));
        savearray(5,10)={sprintf('%2.1f',tmp/length(interval)*100)};
        
        LKneeAY=Data.LKneeAY(interval);
        LKneeV=Data.LKneeV(interval);
        LKneeAc=Data.LKneeAc(interval);
        
        interval=(interval-min(interval))/(max(interval)-min(interval)); 
        for i=1:length(interval)
            savearray(i+1,1:7)=[{interval(i)},{Data.xcompL(i)},{Data.ycompL(i)},{Data.distL(i)},{LKneeAY(i)},{LKneeV(i)},{LKneeAc(i)}];
        end
    end
    if ~isempty(Data.RSPtime)
        interval=[Data.RSPtime(1):Data.RSPtime(2)];
        
        tmp=length(find(Data.xcompR>0 & Data.ycompR>0));
        savearray(2,21)={sprintf('%2.1f',tmp/length(interval)*100)};
        tmp=length(find(Data.xcompR>0 & Data.ycompR<0));
        savearray(3,21)={sprintf('%2.1f',tmp/length(interval)*100)};
        tmp=length(find(Data.xcompR<0 & Data.ycompR<0));
        savearray(4,21)={sprintf('%2.1f',tmp/length(interval)*100)};
        tmp=length(find(Data.xcompR<0 & Data.ycompR>0));
        
        RKneeAY=Data.RKneeAY(interval);
        RKneeV=Data.RKneeV(interval);
        RKneeAc=Data.RKneeAc(interval);
        
        interval=(interval-min(interval))/(max(interval)-min(interval)); 
        savearray(5,21)={sprintf('%2.1f',tmp/length(interval)*100)};
        for i=1:length(interval)
            savearray(i+1,12:18)=[{interval(i)},{Data.xcompR(i)},{Data.ycompR(i)},{Data.distR(i)},{RKneeAY(i)},{RKneeV(i)},{RKneeAc(i)}];
        end
    end 
        
    if ~isempty(savearray)    
        xlswrite([File.filename{File.select} '.xls'],savearray);
    end

elseif strcmp(action,'exportall'),
    for i=1:length(File.filename)
        set(handle.filelist,'value',i);

        MotionAna_UI('filelist') 
        MotionAna_UI('export') 
    end
end
