%% Problem description
% Calculate the projection point A' on a 3D surface E from a given point A beyond the surface
%
% Equation of surface E:
%    ax+by+cz+d=0
% point A:
%    (x1,y1,z1)
% the line pass through point A and perpendicular to surface E:
%    X = x1 + at;
%    Y = y1 + bt;
%    Z = z1 + ct;
% Replace x, y, and z of surface E by the (X,Y,Z) and solve t
%    a(x1 + at)+b(y1 + bt)+c(z1 + ct)+d=0
% Substitute t into L to get the projection point A'
%
% Author: Lu, chia-Feng 2014.9.17
clear 

%% initialize parameters
a=sym('a');
b=sym('b');
c=sym('c');
d=sym('d');
x1=sym('x1');
y1=sym('y1');
z1=sym('z1');

%% formulation and solve t
t=solve('a*(x1+a*t)+b*(y1+b*t)+c*(z1+c*t)+d=0','t');

x2=x1+a*t
y2=y1+a*t
z2=z1+a*t