%% Problem description
% Calculate the projection point A' on a 3D plane T from a given point A beyond the surface
%
% Equation of plane T:
%    ax+by+cz+d=0
% point A:
%    (x1,y1,z1)
% the line pass through point A and perpendicular to plane T:
%    X = x1 + at;
%    Y = y1 + bt;
%    Z = z1 + ct;
% Replace x, y, and z of plane T by the (X,Y,Z) and solve t
%    a(x1 + at)+b(y1 + bt)+c(z1 + ct)+d=0
% Substitute t into L to get the projection point A' (x2,y2,z2)
%
% Author: Lu, chia-Feng 2014.12.17
clear 
tic
%% initialize parameters
syms a b c d x1 y1 z1

%% formulation and solve t
t=solve('a*(x1+a*t)+b*(y1+b*t)+c*(z1+c*t)+d=0','t')

x2=x1+a*t
y2=y1+b*t
z2=z1+c*t
toc