% Loas data from separated folders and save in a structure array
% Chia-Feng Lu 2014.10.15
clear, close all
%% the variable names for each subject's data
VarName={'name','age','gender','height','weight','predata','postdata'};

%% recursivly load the data from folders and save in a structure array
dirname=[pwd filesep 'data'];
dirinfo=dir(dirname);
dirinfo(1:2)=[];  % remove . and ..

rejectdata=[];  % record the subject index to remove
for i=1:length(dirinfo)
    load([dirname filesep dirinfo(i).name filesep dirinfo(i).name '.mat'])
    
    if isempty(predata) || isempty(postdata)
        rejectdata=[rejectdata i];        
    end    
    if isempty(predata)
        fprintf(['The predata from Subject ' name ' are lost! \n'])
    elseif isempty(postdata)
        fprintf(['The postdata from Subject ' name ' are lost! \n'])
    end
    
    if i==5 || i==10 || i==15 || i==20 || i==25 || i==30
        if i==length(dirinfo)
            title='Done!!';
            message=['All Subjects have been loaded. Subject number =' num2str(length(dirinfo)-length(rejectdata))];
        else
            title='Loading progress';
            message=['Subject ' name ' has been loaded!'];
        end
        Sendmail_CFLu('alvin4016@ym.edu.tw',title,message);
    end
    
    
    for j=1:length(VarName)
        eval(['NC(i).' VarName{j} '=' VarName{j} ';']);
    end
end

NC(rejectdata)=[];  % remove the subject with missing data
%% save the structure array as a *.mat matlab file
save('NC.mat','NC')