% Demonstration for image resolution and colormap setup
%   Chia-Feng Lu 2014.10.22

clear, close all

%% load image
load('footimg.mat')

%% image resolution
newdata=imresize(data,0.1);
figure,
subplot(1,2,1),imagesc(data), axis off
subplot(1,2,2),imagesc(newdata), axis off

colormap(gray(256))

%% image colormap
figure,
imagesc(data), axis off, axis equal
colormap(gray(256)), colorbar

figure,
imagesc(data), axis off, axis equal

cmap=[zeros(32,2) linspace(0,1,32)';...                                  % black -> blue
              linspace(0,1,64)' zeros(64,1) linspace(1,0,64)';...   % blue -> red
              ones(32,1) linspace(0,1,32)' zeros(32,1);...             % red -> yellow
              ones(128,2) linspace(0,1,128)'];                                     % yellow -> white
          
colormap(cmap), colorbar
