% Display the motion capture data using VICON marker coordinates
%    Author: Lu, Chia-Feng 2014.10.22
clear, close all

%% load data for left and right markers
load('MotionData.mat')

%% Calculate the mass centers for femur and tibia planes
Lfemur_center=(LT.mark1+LT.mark3+LT.mark4)/3;
Ltibia_center=(LT.mark6+LT.mark2+LT.mark5)/3;

Rfemur_center=(RT.mark1+RT.mark3+RT.mark4)/3;
Rtibia_center=(RT.mark6+RT.mark2+RT.mark5)/3;

alldataL=[LT.mark1; LT.mark2; LT.mark3; LT.mark4; LT.mark5; LT.mark6; LT.mark7;LT.mark8];
alldataR=[RT.mark1; RT.mark2; RT.mark3; RT.mark4; RT.mark5; RT.mark6; RT.mark7;RT.mark8];

%% declare object handles for display
fig1=figure('units','normalize','position',[0.2  0.1 0.6 0.75],'color',[1 1 1]);

%%% first axes for displaying 3D marker coordinates
fig1_axes1=axes('parent',fig1,'position',[0.1300    0.5838    0.7400    0.3412]);
axis([min([alldataL(:,1);alldataR(:,1)]) max([alldataL(:,1);alldataR(:,1)]) ...
         min([alldataL(:,2);alldataR(:,2)]) max([alldataL(:,2);alldataR(:,2)]) ...
         min([alldataL(:,3);alldataR(:,3)]) max([alldataL(:,3);alldataR(:,3)])])
grid on,axis equal
view(60,5),

for i=1:4  % declare line handles
    lineL(i)=line;
    lineR(i)=line;
end
for i=1:2  % declare line handles
    centerL(i)=line;
    centerR(i)=line;
end

%%% second axes for displaying Z-coordinates of left heel and toe markers 
fig1_axes2=axes('parent',fig1,'position',[ 0.1300    0.1100    0.3347    0.3412]);
for i=1:2  % 1: Lt heel, 2: Lt toe
    lineLHT(i)=line; 
end  
axis([1  size(LT.mark7,1) min([LT.mark7(:,3); LT.mark8(:,3); RT.mark7(:,3); RT.mark8(:,3)]) max([LT.mark7(:,3); LT.mark8(:,3); RT.mark7(:,3); RT.mark8(:,3)])])
grid on
title('Left heel (blue) & toe (red)')
ylabel('z-position trajectory')
xlabel('time frame')

%%% third axes for displaying Z-coordinates of ight heel and toe markers 
fig1_axes3=axes('parent',fig1,'position',[ 0.5703    0.1100    0.3347    0.3412]);
for i=1:2  % 1: Rt heel, 2: Rt toe
    lineRHT(i)=line; 
end  
axis([1  size(LT.mark7,1) min([LT.mark7(:,3); LT.mark8(:,3); RT.mark7(:,3); RT.mark8(:,3)]) max([LT.mark7(:,3); LT.mark8(:,3); RT.mark7(:,3); RT.mark8(:,3)])])
grid on
title('Right heel (blue) & toe (red)')
ylabel('z-position trajectory')
xlabel('time frame')

%% display results
for i=1:size(LT.mark1,1)
    set(lineL(1),'xdata',[LT.mark1(i,1) LT.mark3(i,1) LT.mark4(i,1) LT.mark1(i,1)],...
        'ydata',[LT.mark1(i,2) LT.mark3(i,2) LT.mark4(i,2) LT.mark1(i,2)],...
        'zdata',[LT.mark1(i,3) LT.mark3(i,3) LT.mark4(i,3) LT.mark1(i,3)],'color','r','marker','o','linestyle','-','markersize',14)
    set(lineL(2),'xdata',[LT.mark6(i,1) LT.mark2(i,1) LT.mark5(i,1) LT.mark6(i,1)],...
        'ydata',[LT.mark6(i,2) LT.mark2(i,2) LT.mark5(i,2) LT.mark6(i,2)],...
        'zdata',[LT.mark6(i,3) LT.mark2(i,3) LT.mark5(i,3) LT.mark6(i,3)],'color','b','marker','o','linestyle','-','markersize',14)
    set(centerL(1),'xdata',[Lfemur_center(i,1)],...
        'ydata',[Lfemur_center(i,2)],...
        'zdata',[Lfemur_center(i,3)],'color','r','marker','.','linestyle','none','markersize',20)
    set(centerL(2),'xdata',[Ltibia_center(i,1)],...
        'ydata',[Ltibia_center(i,2)],...
        'zdata',[Ltibia_center(i,3)],'color','b','marker','.','linestyle','none','markersize',20)
    set(lineL(3),'xdata',[Ltibia_center(i,1) (0.75*LT.mark7(i,1)+0.25*LT.mark8(i,1))],...
        'ydata',[Ltibia_center(i,2) (0.75*LT.mark7(i,2)+0.25*LT.mark8(i,2))],...
        'zdata',[Ltibia_center(i,3) (0.75*LT.mark7(i,3)+0.25*LT.mark8(i,3))],'color','k','marker','none','linestyle','-','markersize',10,'markerfacecolor','k','linewidth',2)
    set(lineL(4),'xdata',[LT.mark7(i,1) LT.mark8(i,1)],...
        'ydata',[LT.mark7(i,2) LT.mark8(i,2)],...
        'zdata',[LT.mark7(i,3) LT.mark8(i,3)],'color','k','marker','^','linestyle','-','markersize',10,'markerfacecolor','k','linewidth',2)
    
    set(lineR(1),'xdata',[RT.mark1(i,1) RT.mark3(i,1) RT.mark4(i,1) RT.mark1(i,1)],...
        'ydata',[RT.mark1(i,2) RT.mark3(i,2) RT.mark4(i,2) RT.mark1(i,2)],...
        'zdata',[RT.mark1(i,3) RT.mark3(i,3) RT.mark4(i,3) RT.mark1(i,3)],'color','r','marker','o','linestyle','-','markersize',14)
    set(lineR(2),'xdata',[RT.mark6(i,1) RT.mark2(i,1) RT.mark5(i,1) RT.mark6(i,1)],...
        'ydata',[RT.mark6(i,2) RT.mark2(i,2) RT.mark5(i,2) RT.mark6(i,2)],...
        'zdata',[RT.mark6(i,3) RT.mark2(i,3) RT.mark5(i,3) RT.mark6(i,3)],'color','b','marker','o','linestyle','-','markersize',14)
    set(centerR(1),'xdata',[Rfemur_center(i,1)],...
        'ydata',[Rfemur_center(i,2)],...
        'zdata',[Rfemur_center(i,3)],'color','r','marker','.','linestyle','none','markersize',20)
    set(centerR(2),'xdata',[Rtibia_center(i,1)],...
        'ydata',[Rtibia_center(i,2)],...
        'zdata',[Rtibia_center(i,3)],'color','b','marker','.','linestyle','none','markersize',20)
    set(lineR(3),'xdata',[Rtibia_center(i,1) (0.75*RT.mark7(i,1)+0.25*RT.mark8(i,1))],...
        'ydata',[Rtibia_center(i,2) (0.75*RT.mark7(i,2)+0.25*RT.mark8(i,2))],...
        'zdata',[Rtibia_center(i,3) (0.75*RT.mark7(i,3)+0.25*RT.mark8(i,3))],'color','k','marker','none','linestyle','-','markersize',10,'markerfacecolor','k','linewidth',2)
    set(lineR(4),'xdata',[RT.mark7(i,1) RT.mark8(i,1)],...
        'ydata',[RT.mark7(i,2) RT.mark8(i,2)],...
        'zdata',[RT.mark7(i,3) RT.mark8(i,3)],'color','k','marker','^','linestyle','-','markersize',10,'markerfacecolor','k','linewidth',2)
    
    set(lineLHT(1),'xdata',1:i,'ydata',LT.mark7(1:i,3),'color','b','marker','.','linestyle','-')
    set(lineLHT(2),'xdata',1:i,'ydata',LT.mark8(1:i,3),'color','r','marker','.','linestyle','-')
    
    set(lineRHT(1),'xdata',1:i,'ydata',RT.mark7(1:i,3),'color','b','marker','.','linestyle','-')
    set(lineRHT(2),'xdata',1:i,'ydata',RT.mark8(1:i,3),'color','r','marker','.','linestyle','-')
    
    pause(1/samplerate)    
end


