function CoordUI(action)
% Author: Chia-Feng Lu 2014.11.12
global handle Data

if nargin<1,
    action='start';
end;

if strcmp(action,'start'),
    close all
    
    %% figure
    handle.fig_main=figure('units','normalize','position',[0.1  0.1 0.8 0.8],...
        'color',[1 1 1],'name','GUI for Coordination Test, v1.0, Chia-Feng Lu');
    
    %% uipanel
    handle.panel_period = uipanel('Parent',handle.fig_main,...
        'Units','normalized','Position',[0.05 0.51 0.45 0.45],...
        'backgroundcolor',[1 1 1],...
        'Title','Define Period (Y track: forward <-> backward)',...
        'Fontsize',10,'Fontweight','bold');
    handle.panel_epoch = uipanel('Parent',handle.fig_main,...
        'Units','normalized','Position',[0.51 0.51 0.45 0.45],...
        'backgroundcolor',[1 1 1],...
        'Title','Detect Epochs (Y track: forward <-> backward)',...
        'Fontsize',10,'Fontweight','bold');
    handle.panel_control = uipanel('Parent',handle.fig_main,...
        'Units','normalized','Position',[0.05 0.05 0.40 0.45],...
        'backgroundcolor',[1 1 1],...
        'Title','File Control',...
        'Fontsize',10,'Fontweight','bold');
    handle.panel_XYtrack= uipanel('Parent',handle.fig_main,...
        'Units','normalized','Position',[0.46 0.05 0.50 0.45],...
        'backgroundcolor',[1 1 1],...
        'Title','X-Y Track',...
        'Fontsize',10,'Fontweight','bold');
    
    %% uicontrol in panel_control
    % pushbutton
    handle.load =  uicontrol('parent',handle.panel_control,...
        'Units','normalized','Position',[0.03 0.85 0.25 0.10],...
        'Style','Pushbutton',...
        'String','Load',...
        'Callback','CoordUI(''load'')');
    handle.save =  uicontrol('parent',handle.panel_control,...
        'Units','normalized','Position',[0.29 0.85 0.25 0.10],...
        'Style','Pushbutton',...
        'String','Save',...
        'Callback','CoordUI(''save'')');
    handle.estimate =  uicontrol('parent',handle.panel_control,...
        'Units','normalized','Position',[0.55 0.85 0.25 0.10],...
        'Style','Pushbutton',...
        'String','Estimate',...
        'Callback','CoordUI(''estimate'')');
    handle.result=uicontrol('Parent',handle.panel_control,...
        'Units','normalized','Position',[0.03 0.02 0.94 0.82],...
        'Style','listbox',...
        'BackgroundColor',[1 1 1],...
        'ForegroundColor',[0 0 0],...
        'String','',...
        'enable','off',...
        'max',2);
    
    %% uicontrol in panel_period
    handle.axes_period=axes('parent',handle.panel_period,...
        'position',[0.10 0.15 0.70 0.80]);
    xlabel('Data Points'), grid on
    handle.line_ytrack_period=line('parent',handle.axes_period);
    handle.line_period_locate=line('parent',handle.axes_period);
    for i=1:4 % 2 for start timepoints, 2 for end timepoints
        handle.line_period_tp(i)=line('parent',handle.axes_period);
    end
    
    handle.ref_period =  uicontrol('parent',handle.panel_period,...
        'Units','normalized','Position',[0.81 0.85 0.18 0.10],...
        'Style','Pushbutton',...
        'String','Reference',...
        'Callback','CoordUI(''ref_period'')');
    handle.ref_start =  uicontrol('parent',handle.panel_period,...
        'Units','normalized','Position',[0.81 0.76 0.18 0.08],...
        'Style','Edit',...
        'BackgroundColor',[1 1 1],...
        'String','NaN');
    handle.ref_end =  uicontrol('parent',handle.panel_period,...
        'Units','normalized','Position',[0.81 0.67 0.18 0.08],...
        'Style','Edit',...
        'BackgroundColor',[1 1 1],...
        'String','NaN');
    
    handle.trial_period =  uicontrol('parent',handle.panel_period,...
        'Units','normalized','Position',[0.81 0.54 0.18 0.10],...
        'Style','Pushbutton',...
        'String','Trials',...
        'Callback','CoordUI(''trial_period'')');
    handle.trial_start =  uicontrol('parent',handle.panel_period,...
        'Units','normalized','Position',[0.81 0.45 0.18 0.08],...
        'Style','Edit',...
        'BackgroundColor',[1 1 1],...
        'String','NaN');
    handle.trial_end =  uicontrol('parent',handle.panel_period,...
        'Units','normalized','Position',[0.81 0.36 0.18 0.08],...
        'Style','Edit',...
        'BackgroundColor',[1 1 1],...
        'String','NaN');
    
    %% uicontrol in panel_epoch
    handle.axes_epoch=axes('parent',handle.panel_epoch,...
        'position',[0.10 0.15 0.70 0.80]);
    xlabel('Data Points'), grid on
    handle.line_ytrack_epoch=line('parent',handle.axes_epoch);
    handle.line_threshold=line('parent',handle.axes_epoch,...
        'color',[1 0 0],'linestyle',':','linewidth',2);
    for i=1:6
        handle.line_epoch(i)=line('parent',handle.axes_epoch);
    end
    
    handle.slider_threshold =  uicontrol('parent',handle.panel_epoch,...
        'Units','normalized','Position',[0.81 0.15 0.04 0.80],...
        'Style','slider',...
        'min',0,'max',1,...
        'value',0,...
        'sliderstep',[0.01 0.1],...
        'Callback','CoordUI(''slider_threshold'')');
    handle.edit_threshold =  uicontrol('parent',handle.panel_epoch,...
        'Units','normalized','Position',[0.86 0.87 0.13 0.08],...
        'Style','Edit',...
        'BackgroundColor',[1 1 1],...
        'String','NaN',...
        'Callback','CoordUI(''edit_threshold'')');
    handle.detect =  uicontrol('parent',handle.panel_epoch,...
        'Units','normalized','Position',[0.81 0.04 0.18 0.10],...
        'Style','Pushbutton',...
        'String','Detect',...
        'Callback','CoordUI(''detect'')');
    
    %% uicontrol in panel_XYtrack
    for i=1:6 % 1 for reference, 2~6 for trial epochs
        if i==1
            handle.axes_xytrack(i)=axes('parent',handle.panel_XYtrack,...
                'position',[0.05+(i-1)*0.15 0.10 0.15 0.80]);
            title('Reference')
        else
            handle.axes_xytrack(i)=axes('parent',handle.panel_XYtrack,...
                'position',[0.05+(i-1)*0.15 0.10 0.15 0.80]);
            title(['Epoch #' num2str(i-1)])
        end
        grid on
        
        handle.line_xytrack(i,1)=line('parent',handle.axes_xytrack(i),...
            'color',[1 0 0]);    
        handle.line_xytrack(i,2)=line('parent',handle.axes_xytrack(i),...
            'color',[0 0 1]);    
    end
    
    handle.interp =  uicontrol('parent',handle.panel_XYtrack,...
        'Units','normalized','Position',[0.15 0.98 0.15 0.1],...
        'Style','checkbox',...
        'BackgroundColor',[1 1 1],...
        'String','Interpolated',...
        'value',0,...
        'Callback','CoordUI(''interp'')');
   
elseif strcmp(action,'load'),
    % load data from an Excel file
    [filename filepath]=uigetfile({'*.xls;*.xlsx'});
    [data,txt,raw]=xlsread([filepath filename]);
    
    Data.samplerate=data(1); % sampling rate in Hz
    data(1:6,:)=[]; % remove first 6 rows
    Data.data=data;
    
    % display the Y track on panel_period and panel_epoch
    set(handle.line_ytrack_period,...
           'xdata',Data.data(:,1),'ydata',Data.data(:,3))
    set(handle.axes_period,...
           'xlim',[min(Data.data(:,1)) max(Data.data(:,1))],...
           'ylim',[min(Data.data(:,3)) max(Data.data(:,3))])
       
    set(handle.line_ytrack_epoch,...
           'xdata',Data.data(:,1),'ydata',Data.data(:,3))
    set(handle.axes_epoch,...
           'xlim',[min(Data.data(:,1)) max(Data.data(:,1))],...
           'ylim',[min(Data.data(:,3)) max(Data.data(:,3))])   
    
    % set the default threshold value on panel_epoch
    Data.threshold=max(Data.data(:,3))*0.8;
    
    set(handle.edit_threshold,'String',num2str(Data.threshold))
    set(handle.slider_threshold,'value',Data.threshold,...
        'min',min(Data.data(:,3)),'max',max(Data.data(:,3)))
    set(handle.line_threshold,...
        'xdata',[min(Data.data(:,1)) max(Data.data(:,1))],...
        'ydata',[Data.threshold Data.threshold])
       
elseif strcmp(action,'ref_period'),
    Data.ref_period=[];
    
    set(handle.fig_main,'pointer','crosshair',...
             'windowbuttonmotionfcn','CoordUI(''move_ref'')')
    set(handle.axes_period,'buttondownfcn','CoordUI(''down_ref'')');
    set(handle.line_ytrack_period,'buttondownfcn','CoordUI(''down_ref'')');
    set(handle.line_period_locate,'buttondownfcn','CoordUI(''down_ref'')');

elseif strcmp(action,'move_ref'),
    tmp=round(get(handle.axes_period,'currentpoint'));
    tmp=tmp(1);
    
    if isempty(Data.ref_period)  % for start point
        set(handle.ref_start,'string',num2str(tmp))
        set(handle.line_period_locate,...
            'xdata',[tmp tmp],...
            'ydata',[min(Data.data(:,3)) max(Data.data(:,3))],...
            'color',[1 0 0],'linewidth',2)
    else    % for end point
        set(handle.ref_end,'string',num2str(tmp))        
        set(handle.line_period_locate,...
            'xdata',[tmp tmp],...
            'ydata',[min(Data.data(:,3)) max(Data.data(:,3))],...
            'color',[0 0 1],'linewidth',2)
    end    
    
elseif strcmp(action,'down_ref'),    
    tmp=round(get(handle.axes_period,'currentpoint'));
    tmp=tmp(1);
        
    if isempty(Data.ref_period)  % for start point
        Data.ref_period=tmp;
        
        set(handle.ref_start,'string',num2str(tmp))
        set(handle.line_period_tp(1),...
              'xdata',[tmp tmp],...
              'ydata',[min(Data.data(:,3)) max(Data.data(:,3))],...
              'color',[1 0 0],'linewidth',2,'linestyle',':')
    else    % for end point
        Data.ref_period=[Data.ref_period tmp];
        
        set(handle.ref_end,'string',num2str(tmp))        
        set(handle.line_period_tp(2),...
              'xdata',[tmp tmp],...
              'ydata',[min(Data.data(:,3)) max(Data.data(:,3))],...
              'color',[0 0 1],'linewidth',2,'linestyle',':')
        
        set(handle.line_period_locate,'xdata',[],'ydata',[])
        set(handle.fig_main,'pointer','arrow',...
            'windowbuttonmotionfcn','')
        set(handle.axes_period,'buttondownfcn','');
        set(handle.line_ytrack_period,'buttondownfcn',''); 
        set(handle.line_period_locate,'buttondownfcn',''); 
    end
    
elseif strcmp(action,'trial_period'),
    Data.trial_period=[];
    
    set(handle.fig_main,'pointer','crosshair',...
             'windowbuttonmotionfcn','CoordUI(''move_trial'')')
    set(handle.axes_period,'buttondownfcn','CoordUI(''down_trial'')');
    set(handle.line_ytrack_period,'buttondownfcn','CoordUI(''down_trial'')');
    set(handle.line_period_locate,'buttondownfcn','CoordUI(''down_trial'')');

elseif strcmp(action,'move_trial'),
    tmp=round(get(handle.axes_period,'currentpoint'));
    tmp=tmp(1);
    
    if isempty(Data.trial_period)  % for start point
        set(handle.trial_start,'string',num2str(tmp))
        set(handle.line_period_locate,...
            'xdata',[tmp tmp],...
            'ydata',[min(Data.data(:,3)) max(Data.data(:,3))],...
            'color',[1 0 0],'linewidth',2)
    else    % for end point
        set(handle.trial_end,'string',num2str(tmp))        
        set(handle.line_period_locate,...
            'xdata',[tmp tmp],...
            'ydata',[min(Data.data(:,3)) max(Data.data(:,3))],...
            'color',[0 0 1],'linewidth',2)
    end    
    
elseif strcmp(action,'down_trial'),    
    tmp=round(get(handle.axes_period,'currentpoint'));
    tmp=tmp(1);
        
    if isempty(Data.trial_period)  % for start point
        Data.trial_period=tmp;
        
        set(handle.trial_start,'string',num2str(tmp))
        set(handle.line_period_tp(3),...
              'xdata',[tmp tmp],...
              'ydata',[min(Data.data(:,3)) max(Data.data(:,3))],...
              'color',[1 0 0],'linewidth',2,'linestyle',':')
    else    % for end point
        Data.trial_period=[Data.trial_period tmp];
        
        set(handle.trial_end,'string',num2str(tmp))    
        set(handle.line_period_tp(4),...
              'xdata',[tmp tmp],...
              'ydata',[min(Data.data(:,3)) max(Data.data(:,3))],...
              'color',[0 0 1],'linewidth',2,'linestyle',':')
        
        set(handle.line_period_locate,'xdata',[],'ydata',[])
        set(handle.fig_main,'pointer','arrow',...
            'windowbuttonmotionfcn','')
        set(handle.axes_period,'buttondownfcn','');
        set(handle.line_ytrack_period,'buttondownfcn',''); 
        set(handle.line_period_locate,'buttondownfcn',''); 
    end
    
    
elseif strcmp(action,'slider_threshold'),
    Data.threshold=get(handle.slider_threshold,'value');
    
    set(handle.edit_threshold,'String',num2str(Data.threshold))
    set(handle.slider_threshold,'value',Data.threshold,...
        'min',min(Data.data(:,3)),'max',max(Data.data(:,3)))
    set(handle.line_threshold,...
        'xdata',[min(Data.data(:,1)) max(Data.data(:,1))],...
        'ydata',[Data.threshold Data.threshold])
    
elseif strcmp(action,'edit_threshold'),
    Data.threshold=str2num(get(handle.edit_threshold,'string'));
    if Data.threshold>max(Data.data(:,3))
        Data.threshold=max(Data.data(:,3));
    elseif Data.threshold<min(Data.data(:,3))
        Data.threshold=min(Data.data(:,3));
    end
    
    set(handle.edit_threshold,'String',num2str(Data.threshold))
    set(handle.slider_threshold,'value',Data.threshold,...
        'min',min(Data.data(:,3)),'max',max(Data.data(:,3)))
    set(handle.line_threshold,...
        'xdata',[min(Data.data(:,1)) max(Data.data(:,1))],...
        'ydata',[Data.threshold Data.threshold])
    
elseif strcmp(action,'detect'),
    % automatically cut trial into several epochs
    interval=Data.trial_period(1):Data.trial_period(2);
    ind=find(Data.data(interval,3)>=Data.threshold);
    
    % separate into several segments
    ind_break=find(diff(ind)>2); % locate discontinuous points
    for i=1:length(ind_break)
        if i==1
            indseg{i}=1:ind(ind_break(i));
        else
            indseg{i}=ind(ind_break(i-1)+1:ind_break(i));
        end
    end
    indseg{i+1}=ind(ind_break(i)+1:end);
    
    for i=1:length(indseg)
        indseg{i}=interval(indseg{i}); % translate back to the original time frame
    end
    
    % find maximum in each segment as the cut point
    indmax=[];
    for i=1:length(indseg)
        if i==1
            indmax(i)=Data.trial_period(1); 
        elseif i==length(indseg)
            indmax(i)=Data.trial_period(2); 
        else
            [v,indtmp]=max(Data.data(indseg{i},3));
            indmax(i)=indseg{i}(indtmp(1));
        end
    end

    % save segmented trial data into a cell array    
    Data.epoch={};
    Data.epoch{1}=Data.data(Data.ref_period(1):Data.ref_period(2),1:4);
    for i=1:length(indmax)-1
        Data.epoch{i+1}=Data.data(indmax(i):indmax(i+1),1:4);
    end
    
    % display detected epochs
    set(handle.line_epoch(:),'xdata',[],'ydata',[])
    cmap={'r','g','b','k','y','c'};
    for i=1:length(Data.epoch)
        set(handle.line_epoch(i),'xdata',Data.epoch{i}(:,1),...
                                                      'ydata',Data.epoch{i}(:,3),...
                                                      'color',cmap{i},'linewidth',2)
    end    
    
    % separate epochs into "go" and "back"
    Data.epochgo={};
    Data.epochback={};
    for i=1:length(Data.epoch)
        [v,indtarget]=min(Data.epoch{i}(:,3));  % the index of target for each epoch
        Data.epochgo{i}=Data.epoch{i}(1:indtarget(1),:);
        Data.epochback{i}=Data.epoch{i}(indtarget(1):end,:);
    end
    
    % check whether replace the reference track by interpolation
    if get(handle.interp,'value')==1
        t1=Data.epochgo{1}(1,1);
        t2=Data.epochgo{1}(end,1);
        for i=1:3 % 1 for x, 2 for y, 3 for z
            c1=Data.epochgo{1}(1,i);
            c2=Data.epochgo{1}(end,i);
            
            for j=1:size(Data.epochgo{1},1)
                ta=Data.epochgo{1}(j,1);
                ca=(c2-c1)*((ta-t1)/(t2-t1))+c1;
                Data.epochgo{1}(j,i)=ca;
            end
        end
        
        t1=Data.epochback{1}(1,1);
        t2=Data.epochback{1}(end,1);
        Data.epochback{1}(1,2:4)=Data.epochgo{1}(end,2:4);
        Data.epochback{1}(end,2:4)=Data.epochgo{1}(1,2:4);
        for i=1:3 % 1 for x, 2 for y, 3 for z
            c1=Data.epochback{1}(1,i);
            c2=Data.epochback{1}(end,i);
            
            for j=1:size(Data.epochback{1},1)
                ta=Data.epochback{1}(j,1);
                ca=(c2-c1)*((ta-t1)/(t2-t1))+c1;
                Data.epochback{1}(j,i)=ca;
            end
        end
        
    end
    
    CoordUI('display_xytrack')

elseif strcmp(action,'interp'),    
    CoordUI('detect')
    
elseif strcmp(action,'display_xytrack'),
    % display XY track  
for i=1:length(Data.epoch)
        set(handle.line_xytrack(i,1),'color',[1 0 0],...
                   'xdata',Data.epochgo{i}(:,2),...
                   'ydata',Data.epochgo{i}(:,3))
        set(handle.line_xytrack(i,2),'color',[0 0 1],...
                   'xdata',Data.epochback{i}(:,2),...
                   'ydata',Data.epochback{i}(:,3))       
        
        set(handle.axes_xytrack(i),'xlim',[min(Data.data(:,2)) max(Data.data(:,2))],...
                           'ylim',[min(Data.data(:,3)) max(Data.data(:,3))],...
                           'ydir','reverse','DataAspectRatio',[1 1 1])      
    end
    
elseif strcmp(action,'estimate'),
    % calculate the spatial difference between trial and reference
    Data.epochgodiff={};
    Data.epochbackdiff={};
    for i=2:length(Data.epochgo) % 1st trial is reference
        ref=Data.epochgo{1}(:,2:4);
        for j=1:size(Data.epochgo{i},1)
            trialpt=Data.epochgo{i}(j,2:4);
            Data.epochgodiff{i-1}(j,1)=min(sqrt(sum((ones(size(ref,1),1)*trialpt-ref).^2,2)));
        end
        
        ref=Data.epochback{1}(:,2:4);
        for j=1:size(Data.epochback{i},1)
            trialpt=Data.epochback{i}(j,2:4);
            Data.epochbackdiff{i-1}(j,1)=min(sqrt(sum((ones(size(ref,1),1)*trialpt-ref).^2,2)));
        end
    end
    
    % calculate the mean and std for each trial
    Data.Meangodiff=[];
    Data.Stdgodiff=[];
    Data.Meanbackdiff=[];
    Data.Stdbackdiff=[];
    
    Data.Durationgo=[];
    Data.Durationback=[];
    Data.printstr={};
    for i=1:length(Data.epochgodiff)
        Data.Meangodiff(i)=mean(Data.epochgodiff{i});
        Data.Stdgodiff(i)=std(Data.epochgodiff{i});
        Data.Meanbackdiff(i)=mean(Data.epochbackdiff{i});
        Data.Stdbackdiff(i)=std(Data.epochbackdiff{i});
        Data.Durationgo(i)=size(Data.epochgo{i},1)/Data.samplerate;
        Data.Durationback(i)=size(Data.epochback{i},1)/Data.samplerate;
        
        Data.printstr{length(Data.printstr)+1}=['[Trial #' num2str(i) '] Go(' num2str(Data.Durationgo(i)) 's): ' num2str(Data.Meangodiff(i)) ' +- ' num2str(Data.Stdgodiff(i))...
            '/Back(' num2str(Data.Durationback(i)) 's): ' num2str(Data.Meanbackdiff(i)) ' +- ' num2str(Data.Stdbackdiff(i))];
    end
    Data.printstr{length(Data.printstr)+1}=['[All Trials] Go(' num2str(mean(Data.Durationgo)) '+-' num2str(std(Data.Durationgo)) 's): ' num2str(mean(Data.Meangodiff))...
        ' /Back(' num2str(mean(Data.Durationback)) '+-' num2str(std(Data.Durationback)) 's): ' num2str(mean(Data.Meanbackdiff))];
    
    % display accumulated shifting
    Data.printstr{length(Data.printstr)+2}='<Accumulated Results>';
    Data.AllDiff=[];
    for i=1:length(Data.epochgodiff)
        Data.Duration(i)=Data.Durationgo(i)+Data.Durationback(i);
        Data.AccuDiff(i)=sum(Data.epochgodiff{i})+sum(Data.epochbackdiff{i});
        Data.AllDiff=[Data.AllDiff; Data.epochgodiff{i};Data.epochbackdiff{i}];
        Data.printstr{length(Data.printstr)+1}=['[Trial #' num2str(i) '] Duration =' num2str(Data.Duration(i))...
            's, Difference = ' num2str(Data.AccuDiff(i)) ', Average = '  num2str(Data.AccuDiff(i)/(length(Data.epochgodiff{i})+length(Data.epochbackdiff{i})))];
    end
    
    Data.printstr{length(Data.printstr)+1}=['[All Trials] Duration =' num2str(mean(Data.Duration)) ' +- ' num2str(std(Data.Duration))...
        's, Difference = ' num2str(mean(Data.AccuDiff)) ' +- ' num2str(std(Data.AllDiff))...
        ', Average = ' num2str(mean(Data.AllDiff)) ' +- ' num2str(std(Data.AllDiff))];
    
    set(handle.result,'string',Data.printstr,'enable','on')
    
elseif strcmp(action,'save'),    
    [filename filepath]=uiputfile('*.mat');
    save([filepath filename],'Data')
    
end