function ThresSlider(action)
% Author: Chia-Feng Lu 2014.11.12
global handle Data

if nargin<1,
    action='start';
end;

if strcmp(action,'start'),
    close all
    %% figure
    handle.fig_main=figure('units','normalize','position',[0.2  0.2 0.6 0.6],...
        'color',[1 1 1],'name','GUI for Thresholding');
    
    %% uipanel
    handle.panel_epoch = uipanel('Parent',handle.fig_main,...
        'Units','normalized','Position',[0.05 0.05 0.90 0.90],...
        'backgroundcolor',[1 1 1],...
        'Title','Detect Epochs (Y track: forward <-> backward)',...
        'Fontsize',10,'Fontweight','bold');
    
    %% uicontrol in panel_epoch
    handle.load =  uicontrol('parent',handle.panel_epoch,...
        'Units','normalized','Position',[0.86 0.15 0.13 0.10],...
        'Style','Pushbutton',...
        'String','Load',...
        'Callback','ThresSlider(''load'')');
    
    handle.axes_epoch=axes('parent',handle.panel_epoch,...
        'position',[0.10 0.15 0.70 0.80]);
    xlabel('Data Points'), grid on
    handle.line_ytrack_epoch=line('parent',handle.axes_epoch);
    handle.line_threshold=line('parent',handle.axes_epoch,...
        'color',[1 0 0],'linestyle',':','linewidth',2);
    handle.line_upper=line('parent',handle.axes_epoch);
    
    handle.slider_threshold =  uicontrol('parent',handle.panel_epoch,...
        'Units','normalized','Position',[0.81 0.15 0.04 0.80],...
        'Style','slider',...
        'min',0,'max',1,...
        'value',0,...
        'sliderstep',[0.01 0.1],...
        'Callback','ThresSlider(''slider_threshold'')');
    handle.edit_threshold =  uicontrol('parent',handle.panel_epoch,...
        'Units','normalized','Position',[0.86 0.87 0.13 0.08],...
        'Style','Edit',...
        'BackgroundColor',[1 1 1],...
        'String','NaN',...
        'Callback','ThresSlider(''edit_threshold'')');
    handle.detect =  uicontrol('parent',handle.panel_epoch,...
        'Units','normalized','Position',[0.86 0.04 0.13 0.10],...
        'Style','Pushbutton',...
        'String','Detect',...
        'Callback','ThresSlider(''detect'')');
       
elseif strcmp(action,'load'),
    % load data from an Excel file
    [filename filepath]=uigetfile({'*.xls;*.xlsx'});
    [data,txt,raw]=xlsread([filepath filename]);
    
    Data.samplerate=data(1); % sampling rate in Hz
    data(1:6,:)=[]; % remove first 6 rows
    Data.data=data;
    
    % display the Y track 
    set(handle.line_ytrack_epoch,...
           'xdata',Data.data(:,1),'ydata',Data.data(:,3))
    set(handle.axes_epoch,...
           'xlim',[min(Data.data(:,1)) max(Data.data(:,1))],...
           'ylim',[min(Data.data(:,3)) max(Data.data(:,3))])   
    
    % set the default threshold value on panel_epoch
    Data.threshold=max(Data.data(:,3))*0.8;
    
    set(handle.edit_threshold,'String',num2str(Data.threshold))
    set(handle.slider_threshold,'value',Data.threshold,...
        'min',min(Data.data(:,3)),'max',max(Data.data(:,3)))
    set(handle.line_threshold,...
        'xdata',[min(Data.data(:,1)) max(Data.data(:,1))],...
        'ydata',[Data.threshold Data.threshold])
       
elseif strcmp(action,'slider_threshold'),
    Data.threshold=get(handle.slider_threshold,'value');
    
    set(handle.edit_threshold,'String',num2str(Data.threshold))
    set(handle.slider_threshold,'value',Data.threshold,...
        'min',min(Data.data(:,3)),'max',max(Data.data(:,3)))
    set(handle.line_threshold,...
        'xdata',[min(Data.data(:,1)) max(Data.data(:,1))],...
        'ydata',[Data.threshold Data.threshold])
    
elseif strcmp(action,'edit_threshold'),
    Data.threshold=str2num(get(handle.edit_threshold,'string'));
    if Data.threshold>max(Data.data(:,3))
        Data.threshold=max(Data.data(:,3));
    elseif Data.threshold<min(Data.data(:,3))
        Data.threshold=min(Data.data(:,3));
    end
    
    set(handle.edit_threshold,'String',num2str(Data.threshold))
    set(handle.slider_threshold,'value',Data.threshold,...
        'min',min(Data.data(:,3)),'max',max(Data.data(:,3)))
    set(handle.line_threshold,...
        'xdata',[min(Data.data(:,1)) max(Data.data(:,1))],...
        'ydata',[Data.threshold Data.threshold])
    
elseif strcmp(action,'detect'),
    ind=find(Data.data(:,3)>=Data.threshold);
    
    set(handle.line_upper,...
        'xdata',ind,'ydata',Data.data(ind,3),...
        'linewidth',2,'color',[1 0 0],...
        'linestyle','none','marker','*')        
end