function IntervROIUI_mod(action)
% Author: Chia-Feng Lu 2014.11.12
global handle Data

if nargin<1,
    action='start';
end;

if strcmp(action,'start'),
    close all
    
    %% figure
    handle.fig_main=figure('units','normalize','position',[0.2  0.2 0.6 0.6],...
        'color',[1 1 1],'name','GUI for Interval ROI, Chia-Feng Lu');
    
    %% uipanel
    handle.panel_period = uipanel('Parent',handle.fig_main,...
        'Units','normalized','Position',[0.05 0.05 0.90 0.90],...
        'backgroundcolor',[1 1 1],...
        'Title','Define Period (Y track: forward <-> backward)',...
        'Fontsize',10,'Fontweight','bold');
    
   %% uicontrol in panel_period
    handle.load =  uicontrol('parent',handle.panel_period,...
        'Units','normalized','Position',[0.81 0.15 0.18 0.10],...
        'Style','Pushbutton',...
        'String','Load',...
        'Callback','IntervROIUI_mod(''load'')');
   
    handle.axes_period=axes('parent',handle.load,...
        'position',[0.10 0.15 0.70 0.80]);
    xlabel('Data Points'), grid on
    handle.line_ytrack_period=line('parent',handle.axes_period);
    handle.line_period_locate=line('parent',handle.axes_period);
    for i=1:4 % 2 for start timepoints, 2 for end timepoints
        handle.line_period_tp(i)=line('parent',handle.axes_period);
    end
    
    handle.ref_period =  uicontrol('parent',handle.panel_period,...
        'Units','normalized','Position',[0.81 0.85 0.18 0.10],...
        'Style','Pushbutton',...
        'String','Reference',...
        'Callback','IntervROIUI_mod(''ref_period'')');
    handle.ref_start =  uicontrol('parent',handle.panel_period,...
        'Units','normalized','Position',[0.81 0.76 0.18 0.08],...
        'Style','Edit',...
        'BackgroundColor',[1 1 1],...
        'String','NaN');
    handle.ref_end =  uicontrol('parent',handle.panel_period,...
        'Units','normalized','Position',[0.81 0.67 0.18 0.08],...
        'Style','Edit',...
        'BackgroundColor',[1 1 1],...
        'String','NaN');
    
    handle.trial_period =  uicontrol('parent',handle.panel_period,...
        'Units','normalized','Position',[0.81 0.54 0.18 0.10],...
        'Style','Pushbutton',...
        'String','Trials',...
        'Callback','IntervROIUI_mod(''trial_period'')');
    handle.trial_start =  uicontrol('parent',handle.panel_period,...
        'Units','normalized','Position',[0.81 0.45 0.18 0.08],...
        'Style','Edit',...
        'BackgroundColor',[1 1 1],...
        'String','NaN');
    handle.trial_end =  uicontrol('parent',handle.panel_period,...
        'Units','normalized','Position',[0.81 0.36 0.18 0.08],...
        'Style','Edit',...
        'BackgroundColor',[1 1 1],...
        'String','NaN');
   
elseif strcmp(action,'load'),
    % load data from an Excel file
    [filename filepath]=uigetfile({'*.xls;*.xlsx'});
    [data,txt,raw]=xlsread([filepath filename]);
    
    Data.samplerate=data(1); % sampling rate in Hz
    data(1:6,:)=[]; % remove first 6 rows
    Data.data=data;
    
    % display the Y track on panel_period and panel_epoch
    set(handle.line_ytrack_period,...
           'xdata',Data.data(:,1),'ydata',Data.data(:,3))
    set(handle.axes_period,...
           'xlim',[min(Data.data(:,1)) max(Data.data(:,1))],...
           'ylim',[min(Data.data(:,3)) max(Data.data(:,3))])
       
           
elseif strcmp(action,'ref_period'),
    Data.ref_period=[];
    
    set(handle.fig_main,'pointer','crosshair',...
             'windowbuttonmotionfcn','IntervROIUI_mod(''move_ref'')')
    set(handle.axes_period,'buttondownfcn','IntervROIUI_mod(''down_ref'')');
    set(handle.line_ytrack_period,'buttondownfcn','IntervROIUI_mod(''down_ref'')');
    set(handle.line_period_locate,'buttondownfcn','IntervROIUI_mod(''down_ref'')');

elseif strcmp(action,'move_ref'),
    tmp=round(get(handle.axes_period,'currentpoint'));
    tmp=tmp(1);
    
    if isempty(Data.ref_period)  % for start point
        set(handle.ref_start,'string',num2str(tmp))
        set(handle.line_period_locate,...
            'xdata',[tmp tmp],...
            'ydata',[min(Data.data(:,3)) max(Data.data(:,3))],...
            'color',[1 0 0],'linewidth',2)
    else    % for end point
        set(handle.ref_end,'string',num2str(tmp))        
        set(handle.line_period_locate,...
            'xdata',[tmp tmp],...
            'ydata',[min(Data.data(:,3)) max(Data.data(:,3))],...
            'color',[0 0 1],'linewidth',2)
    end    
    
elseif strcmp(action,'down_ref'),    
    tmp=round(get(handle.axes_period,'currentpoint'));
    tmp=tmp(1);
        
    if isempty(Data.ref_period)  % for start point
        Data.ref_period=tmp;
        
        set(handle.ref_start,'string',num2str(tmp))
        set(handle.line_period_tp(1),...
              'xdata',[tmp tmp],...
              'ydata',[min(Data.data(:,3)) max(Data.data(:,3))],...
              'color',[1 0 0],'linewidth',2,'linestyle',':')
    else    % for end point
        Data.ref_period=[Data.ref_period tmp];
        
        set(handle.ref_end,'string',num2str(tmp))        
        set(handle.line_period_tp(2),...
              'xdata',[tmp tmp],...
              'ydata',[min(Data.data(:,3)) max(Data.data(:,3))],...
              'color',[0 0 1],'linewidth',2,'linestyle',':')
        
        set(handle.line_period_locate,'xdata',[],'ydata',[])
        set(handle.axes_period,'pointer','arrow',...
            'windowbuttonmotionfcn','')
        set(handle.axes_period,'buttondownfcn','');
        set(handle.line_ytrack_period,'buttondownfcn',''); 
        set(handle.line_period_locate,'buttondownfcn',''); 
    end
    
elseif strcmp(action,'trial_period'),
    Data.trial_period=[];
    
    set(handle.fig_main,'pointer','crosshair',...
             'windowbuttonmotionfcn','IntervROIUI_mod(''move_trial'')')
    set(handle.axes_period,'buttondownfcn','IntervROIUI_mod(''down_trial'')');
    set(handle.line_ytrack_period,'buttondownfcn','IntervROIUI_mod(''down_trial'')');
    set(handle.line_period_locate,'buttondownfcn','IntervROIUI_mod(''down_trial'')');

elseif strcmp(action,'move_trial'),
    tmp=round(get(handle.axes_period,'currentpoint'));
    tmp=tmp(1);
    
    if isempty(Data.trial_period)  % for start point
        set(handle.trial_start,'string',num2str(tmp))
        set(handle.line_period_locate,...
            'xdata',[tmp tmp],...
            'ydata',[min(Data.data(:,3)) max(Data.data(:,3))],...
            'color',[1 0 0],'linewidth',2)
    else    % for end point
        set(handle.trial_end,'string',num2str(tmp))        
        set(handle.line_period_locate,...
            'xdata',[tmp tmp],...
            'ydata',[min(Data.data(:,3)) max(Data.data(:,3))],...
            'color',[0 0 1],'linewidth',2)
    end    
    
elseif strcmp(action,'down_trial'),    
    tmp=round(get(handle.axes_period,'currentpoint'));
    tmp=tmp(1);
        
    if isempty(Data.trial_period)  % for start point
        Data.trial_period=tmp;
        
        set(handle.trial_start,'string',num2str(tmp))
        set(handle.line_period_tp(3),...
              'xdata',[tmp tmp],...
              'ydata',[min(Data.data(:,3)) max(Data.data(:,3))],...
              'color',[1 0 0],'linewidth',2,'linestyle',':')
    else    % for end point
        Data.trial_period=[Data.trial_period tmp];
        
        set(handle.trial_end,'string',num2str(tmp))     
        set(handle.line_period_tp(4),...
              'xdata',[tmp tmp],...
              'ydata',[min(Data.data(:,3)) max(Data.data(:,3))],...
              'color',[0 0 1],'linewidth',2,'linestyle',':')
        
        set(handle.line_period_locate,'xdata',[],'ydata',[])
        set(handle.fig_main,'pointer','arrow',...
            'windowbuttonmotionfcn','')
        set(handle.axes_period,'buttondownfcn','');
        set(handle.line_ytrack_period,'buttondownfcn',''); 
        set(handle.line_period_locate,'buttondownfcn',''); 
    end
end